/*
 * Decompiled with CFR 0.152.
 */
package org.hibara.attachecase.utility;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.BlowfishEngine;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.encoders.Base64;
import org.hibara.attachecase.AttacheCaseConstant;
import org.hibara.attachecase.Options;
import org.hibara.attachecase.entity.FileAttribute;
import org.hibara.attachecase.entity.FileAttribute3;
import org.hibara.attachecase.entity.InfoTable;
import org.hibara.attachecase.io.ByteArrayOutputStream;
import org.hibara.attachecase.io.RandomAccessFile;

public class Utility
implements AttacheCaseConstant {
    private static String osName = System.getProperty("os.name");

    public static String includeTrailingPathDelimiter(String path) {
        if (!path.endsWith(File.separator)) {
            path = String.valueOf(path) + File.separator;
        }
        return path;
    }

    public static String rejectPathTraversal(String path) {
        String work = path;
        while (work.startsWith("../") || work.startsWith("./")) {
            if (work.startsWith("../")) {
                work = work.substring("../".length());
                continue;
            }
            if (!work.startsWith("./")) continue;
            work = work.substring("./".length());
        }
        return work;
    }

    public static long getDiskFreeSpace(String path) throws SecurityException {
        long freeSpace = -1L;
        File f = new File(path);
        if (!f.isFile()) {
            f = f.getParentFile();
        }
        freeSpace = f.getUsableSpace();
        return freeSpace;
    }

    public static boolean setFileAttribute(String path, FileAttribute attr) {
        boolean result = false;
        File f = new File(path);
        if (!f.exists()) {
            return result;
        }
        if ((attr.getAttribute() & 1) != 0) {
            result = f.setWritable(false);
        }
        return result;
    }

    public static void setFileTimeStamp(String path, FileAttribute attr, boolean now) {
        Date modified = null;
        Date create = null;
        if (attr instanceof FileAttribute3) {
            modified = Utility.convetToDate(attr.getModifiedDate(), attr.getModifiedTime());
            create = Utility.convetToDate(attr.getCreateDate(), attr.getCreateTime());
        } else {
            modified = Utility.convetToDate((int)attr.getModifiedDate(), (int)attr.getModifiedTime());
            create = Utility.convetToDate((int)attr.getCreateDate(), (int)attr.getCreateTime());
        }
        FileTime creationTime = FileTime.fromMillis(create.getTime());
        FileTime modifiedTime = FileTime.fromMillis(modified.getTime());
        TimeZone tz = TimeZone.getTimeZone("UTC");
        Calendar cal = Calendar.getInstance(tz);
        FileTime currentTime = FileTime.fromMillis(cal.getTimeInMillis());
        if (now) {
            creationTime = modifiedTime = currentTime;
        }
        if (Double.parseDouble(System.getProperty("java.specification.version")) >= 1.7) {
            try {
                Path p = Paths.get(path, new String[0]);
                Files.setAttribute(p, "creationTime", creationTime, new LinkOption[0]);
                Files.setAttribute(p, "lastModifiedTime", modifiedTime, new LinkOption[0]);
                Files.setAttribute(p, "lastAccessTime", currentTime, new LinkOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            Utility.setFileTimeStamp(path, modified.getTime(), create.getTime(), now);
        }
    }

    private static void setFileTimeStamp(String path, long modified, long create, boolean now) {
        File f = new File(path);
        if (!f.exists()) {
            return;
        }
        if (now) {
            TimeZone tz = TimeZone.getTimeZone("UTC");
            Calendar cal = Calendar.getInstance(tz);
            create = modified = cal.getTimeInMillis();
        }
        f.setLastModified(modified);
    }

    public static boolean isWindows() {
        return osName.toLowerCase().indexOf("windows") != -1;
    }

    public static String replacePlaceHolder(String s, Object[] obj) {
        MessageFormat mf = new MessageFormat(s);
        return mf.format(obj);
    }

    public static Date convetToDate(int date, int time) {
        long day = (long)date * 1000L * 3600L * 24L + (long)time + -62135802000000L;
        TimeZone tz = TimeZone.getDefault();
        return new Date(day += 86400000L + (long)tz.getRawOffset());
    }

    public static Date convetToDate(double date, double time) {
        double day = date * 3600.0 * 24.0 * 1000.0 + (double)Utility.get00010101Time() + 1.728E8 + time * 1000.0;
        return new Date((long)day);
    }

    public static String getDateTime(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        return df.format(date);
    }

    public static boolean isMac() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.startsWith("mac os x");
    }

    public static boolean isAtcFile(File f) {
        boolean result;
        block12: {
            result = false;
            RandomAccessFile fis = null;
            try {
                try {
                    fis = new RandomAccessFile(f, "r");
                    InfoTable infoTable = new InfoTable(fis);
                    infoTable.readFromFile(fis);
                    result = infoTable.isMatchToken();
                }
                catch (Exception e) {
                    result = false;
                    if (fis == null) break block12;
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return result;
    }

    public static int getAtcVersion(File f) {
        int version = -1;
        RandomAccessFile fis = null;
        try {
            fis = new RandomAccessFile(f, "r");
            InfoTable info = new InfoTable(fis);
            info.readFromFile();
            if (!info.isExistToken()) {
                int n = version;
                return n;
            }
            try {
                if (info.getDataVersion() <= 105) {
                    version = 2;
                } else if (info.getDataVersion() > 105 && info.getDataVersion() < 200) {
                    version = 3;
                }
            }
            catch (Exception e) {
                version = -1;
            }
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return version;
    }

    public static String encrypt(String key, String text) {
        try {
            BlowfishEngine engine = new BlowfishEngine();
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)engine);
            KeyParameter keyParameter = new KeyParameter(key.getBytes());
            cipher.init(true, (CipherParameters)keyParameter);
            byte[] input = text.getBytes();
            byte[] output = new byte[cipher.getOutputSize(input.length)];
            int length = cipher.processBytes(input, 0, input.length, output, 0);
            cipher.doFinal(output, length);
            String s = new String(Base64.encode((byte[])output));
            return s;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String decrypt(String key, String encryptText) {
        if (key == null || encryptText == null) {
            return null;
        }
        if (key.length() == 0 || encryptText.length() == 0) {
            return "";
        }
        try {
            BlowfishEngine engine = new BlowfishEngine();
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)engine);
            StringBuilder result = new StringBuilder();
            KeyParameter keyParameter = new KeyParameter(key.getBytes());
            cipher.init(false, (CipherParameters)keyParameter);
            byte[] base64 = Base64.decode((String)encryptText);
            byte[] output = new byte[cipher.getOutputSize(base64.length)];
            int length = cipher.processBytes(base64, 0, base64.length, output, 0);
            cipher.doFinal(output, length);
            String s2 = new String(output);
            int i = 0;
            while (i < s2.length()) {
                char c = s2.charAt(i);
                if (c != '\u0000') {
                    result.append(c);
                }
                ++i;
            }
            return result.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getStartupPath() {
        String path = Utility.includeTrailingPathDelimiter(System.getProperty("user.dir"));
        File dir = null;
        URL url = Options.class.getResource("Options.class");
        String protocol = url.getProtocol();
        if (protocol.equals("jar")) {
            Pattern p = Pattern.compile("(file:/.*)!/");
            Matcher m = p.matcher(url.toString());
            if (!m.find()) {
                return path;
            }
            File jarFile = null;
            try {
                jarFile = new File(new URI(m.group(1)));
            }
            catch (URISyntaxException e) {
                return path;
            }
            dir = jarFile.getParentFile();
        } else if (protocol.equals("file")) {
            File classFile = null;
            try {
                classFile = new File(new URI(url.toString()));
            }
            catch (URISyntaxException e) {
                return path;
            }
            Package pack = Options.class.getPackage();
            if (pack == null) {
                dir = classFile.getParentFile();
            } else {
                String packName = pack.getName();
                String[] dirs = packName.split("\\.");
                dir = classFile.getParentFile();
                int i = 0;
                while (i < dirs.length) {
                    dir = dir.getParentFile();
                    ++i;
                }
            }
        } else {
            return path;
        }
        return dir.getAbsolutePath();
    }

    public static byte[] getRandomSalt(int length) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int i = 0;
        while (i < length) {
            os.write((byte)(Math.floor(Math.random() * 256.0) - 128.0));
            ++i;
        }
        byte[] salt = os.toByteArray();
        try {
            os.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return salt;
    }

    public static long get00010101Time() {
        Date date00010101 = null;
        String dateStr = "00010101 00:00:00";
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd HH:mm:ss");
            date00010101 = sdf.parse(dateStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (date00010101 != null) {
            return date00010101.getTime();
        }
        return 0L;
    }
}

