/*
 * Decompiled with CFR 0.152.
 */
package org.hibara.attachecase.utility;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.hibara.attachecase.AttacheCaseConstant;
import org.hibara.attachecase.entity.ShaEntity;

public class Digest
implements AttacheCaseConstant {
    private static final String SHA1_ALGOLITHM = "SHA1";
    private static final String SHA256_ALGOLITHM = "SHA-256";
    private byte[] fileHeader = new byte[255];
    private byte[] lastBufferData = new byte[255];

    public String getSha256ByString(String path) {
        StringBuilder sb = new StringBuilder();
        try {
            byte[] hash;
            byte[] byArray = hash = this.getSha256(path);
            int n = hash.length;
            int n2 = 0;
            while (n2 < n) {
                int value = byArray[n2];
                int intValue = value;
                if (intValue < 0) {
                    intValue = 255 - (byte)(value ^ 0xFF);
                }
                sb.append(intValue);
                ++n2;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    public byte[] getSha256(String path) throws IOException {
        File f = new File(path);
        byte[] hash = null;
        if (!f.exists()) {
            throw new FileNotFoundException();
        }
        try {
            hash = this.getFileDigest(f, SHA256_ALGOLITHM);
            int i = 0;
            while (i < hash.length) {
                ++i;
            }
        }
        catch (NoSuchAlgorithmException i) {
        }
        catch (IOException e) {
            throw e;
        }
        return hash;
    }

    public ShaEntity getHash(String path) throws IOException {
        File f = new File(path);
        ShaEntity shaEntity = null;
        if (!f.exists()) {
            throw new FileNotFoundException();
        }
        try {
            shaEntity = new ShaEntity();
            byte[] shaHash = this.getFileDigest(f, SHA1_ALGOLITHM);
            byte[] hash = new byte[32];
            int i = 0;
            while (i < shaHash.length) {
                hash[i] = shaHash[i];
                ++i;
            }
            i = 0;
            while (i < hash.length - shaHash.length) {
                hash[shaHash.length + i] = this.lastBufferData[i];
                ++i;
            }
            shaEntity.setHashArray(hash);
            shaEntity.setHashString(shaHash);
            shaEntity.setHeaderArray(this.getHeaderByte(this.fileHeader));
            shaEntity.setHeaderString(this.getHeaderString(shaEntity.getHeaderArray()));
        }
        catch (NoSuchAlgorithmException shaHash) {
        }
        catch (IOException e) {
            throw e;
        }
        return shaEntity;
    }

    private byte[] getFileDigest(File f, String algolithm) throws IOException, NoSuchAlgorithmException {
        BufferedInputStream is = null;
        MessageDigest md = null;
        try {
            is = new BufferedInputStream(new FileInputStream(f));
            byte[] buffer = new byte[255];
            md = MessageDigest.getInstance(algolithm);
            int length = 0;
            int count = 0;
            while ((length = is.read(buffer)) != -1) {
                if (count == 0) {
                    this.fileHeader = Arrays.copyOfRange(buffer, 0, length);
                }
                ++count;
                md.update(buffer, 0, length);
            }
            this.lastBufferData = (byte[])buffer.clone();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return md.digest();
    }

    private String getHeaderString(byte[] array) {
        int pos = this.indexOf(array, (byte)0);
        if (pos == -1) {
            pos += 256;
        }
        int length = array.length < pos ? array.length : pos;
        byte[] buffer = new byte[pos + 1];
        System.arraycopy(array, 0, buffer, 0, length);
        return new String(buffer);
    }

    private byte[] getHeaderByte(byte[] array) {
        int length = array.length > 256 ? 256 : array.length;
        byte[] buffer = new byte[length];
        System.arraycopy(array, 0, buffer, 0, length);
        return buffer;
    }

    public String toEncryptedString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            String hex = String.format("%02x", b);
            sb.append(hex);
            ++n2;
        }
        return sb.toString();
    }

    private int indexOf(byte[] array, byte value) {
        int pos = -1;
        int i = 0;
        while (i < array.length) {
            if (value == array[i]) {
                pos = i;
                break;
            }
            ++i;
        }
        return pos;
    }
}

