/*
 * Decompiled with CFR 0.152.
 */
package org.hibara.attachecase.io;

import java.io.IOException;
import org.hibara.attachecase.io.ByteArrayOutputStream;

public class ZipOutputStream {
    protected ByteArrayOutputStream byteStream = new ByteArrayOutputStream();

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public int read(byte[] buffer) throws IOException {
        int readLength = 0;
        if (this.byteStream.size() > 0) {
            readLength = Math.min(this.byteStream.size(), buffer.length);
            byte[] byteBuffer = this.byteStream.toByteArray();
            int i = 0;
            while (i < readLength) {
                buffer[i] = byteBuffer[i];
                ++i;
            }
            this.byteStream.reset();
            if (this.byteStream.size() - readLength > 0) {
                this.byteStream.write(byteBuffer, readLength, this.byteStream.size() - readLength);
            }
        }
        return readLength;
    }

    public byte[] readAll() throws IOException {
        if (this.byteStream.size() == 0) {
            return null;
        }
        byte[] byteBuffer = this.byteStream.toByteArray();
        this.byteStream.reset();
        return byteBuffer;
    }

    public boolean canRead() {
        return this.byteStream.size() > 0;
    }

    public boolean canRead(int length) {
        if (length == 0) {
            return this.canRead();
        }
        return this.byteStream.size() >= length;
    }

    public void close() {
        try {
            try {
                if (this.byteStream != null) {
                    this.byteStream.close();
                }
            }
            catch (Exception exception) {
                this.byteStream = null;
            }
        }
        finally {
            this.byteStream = null;
        }
    }
}

