/*
 * Decompiled with CFR 0.152.
 */
package org.hibara.attachecase.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.hibara.attachecase.io.ZipOutputStream;

public class ZipDeflateOutputStream
extends ZipOutputStream {
    private DeflaterOutputStream deflateStream;

    public ZipDeflateOutputStream(int level, boolean nowrap) throws IOException {
        Deflater deflater = new Deflater(level, nowrap);
        this.deflateStream = new DeflaterOutputStream((OutputStream)this.byteStream, deflater);
    }

    @Override
    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void write(byte[] buffer) throws IOException {
        this.deflateStream.write(buffer, 0, buffer.length);
    }

    public void write(byte[] buffer, int length) throws IOException {
        this.deflateStream.write(buffer, 0, length);
    }

    public void finish() throws IOException {
        this.deflateStream.flush();
        this.deflateStream.finish();
    }

    @Override
    public boolean canRead() {
        try {
            this.deflateStream.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return super.canRead();
    }

    @Override
    public void close() {
        try {
            try {
                if (this.deflateStream != null) {
                    this.deflateStream.close();
                }
                super.close();
            }
            catch (Exception exception) {
                this.deflateStream = null;
            }
        }
        finally {
            this.deflateStream = null;
        }
    }
}

