/*
 * Decompiled with CFR 0.152.
 */
package org.hibara.attachecase.io;

import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.hibara.attachecase.AttacheCaseConstant;
import org.hibara.attachecase.Confirm;
import org.hibara.attachecase.Options;
import org.hibara.attachecase.entity.FileAttribute;
import org.hibara.attachecase.io.RandomAccessFile;
import org.hibara.attachecase.utility.AbstractProgressListener;

public class FileDeletion
implements AttacheCaseConstant {
    public static final int NO_DELETE = -1;
    public static final int NORMA_DELETE = 0;
    public static final int THOROUGH_DELETE = 1;
    public static final int TRASH_DELETE = 2;
    private static final String TRASH_PATH = ".Trash/";
    private int randomCount;
    private int zeroCount;
    private int deleteMode = -1;
    private int progress;
    private String currentFileName;
    private long allSize = 0L;
    private List<String> fileList;
    private AbstractProgressListener listener = null;

    public FileDeletion() {
        this.zeroCount = 1;
        this.randomCount = 1;
        this.deleteMode = 0;
    }

    public FileDeletion(Options options) {
        this.randomCount = options.getRandomWriteCount();
        this.zeroCount = options.getZeroWriteCount();
        this.deleteMode = options.getDeleteMode();
    }

    public List<String> getFileList() {
        return this.fileList;
    }

    public void setFileList(List<String> fileList) {
        this.fileList = fileList;
    }

    public void setFileListByAttribute(List<FileAttribute> list) {
        this.fileList = new ArrayList<String>();
        for (FileAttribute attr : list) {
            this.fileList.add(attr.getFileNameOnly());
        }
    }

    public void setDeleteFile(String fileName) {
        this.fileList = new ArrayList<String>();
        this.fileList.add(fileName);
    }

    public int getRandomCount() {
        return this.randomCount;
    }

    public void setRandomCount(int randomCount) {
        if (randomCount < 0) {
            randomCount = 1;
        }
        this.randomCount = randomCount;
    }

    public int getZeroCount() {
        return this.zeroCount;
    }

    public void setZeroCount(int zeroCount) {
        if (zeroCount < 0) {
            zeroCount = 1;
        }
        this.zeroCount = zeroCount;
    }

    public int getDeleteMode() {
        return this.deleteMode;
    }

    public int getProgress() {
        return this.progress;
    }

    public String getCurrentFileName() {
        return this.currentFileName;
    }

    public void setDeleteMode(int deleteMode) {
        this.deleteMode = deleteMode;
        if (this.deleteMode == 1) {
            this.randomCount = this.randomCount <= 0 ? 1 : this.randomCount;
            this.zeroCount = this.zeroCount <= 0 ? 1 : this.zeroCount;
        }
    }

    private String getTrashPath() {
        File f = new File(System.getProperty("user.home"), TRASH_PATH);
        return f.exists() ? f.getAbsolutePath() : null;
    }

    private boolean deleteThoroughMode(String path) {
        return this.deleteThoroughMode(new File(path));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean deleteThoroughMode(File f) {
        if (!f.exists()) {
            return false;
        }
        boolean result = true;
        if (f.isDirectory()) {
            File[] files;
            File[] fileArray = files = f.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                result = this.deleteThoroughMode(file);
                if (!result) {
                    return result;
                }
                ++n2;
            }
            return result;
        }
        if (this.listener != null) {
            this.listener.publishFileName(String.valueOf(Confirm.resources.getString("MSG_DELETE_CONTINUE")) + f.getName());
        }
        RandomAccessFile fs = null;
        try {
            try {
                fs = new RandomAccessFile(f, "rw");
                this.deleteByRandomData(fs);
                this.deleteByZeroData(fs);
                result = true;
                return result;
            }
            catch (IOException e) {
                result = false;
                e.printStackTrace();
                if (fs == null) return result;
                try {
                    fs.close();
                    return result;
                }
                catch (IOException iOException) {}
            }
            return result;
        }
        finally {
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private boolean deleteNormalMode(String path) {
        return this.deleteNormalMode(new File(path));
    }

    private boolean deleteNormalMode(File f) {
        if (!f.exists()) {
            return false;
        }
        if (this.listener != null) {
            this.listener.publishFileName(String.valueOf(Confirm.resources.getString("MSG_DELETE_CONTINUE")) + f.getName());
        }
        f.setWritable(true);
        return FileUtils.deleteQuietly((File)f);
    }

    private boolean deleteTrashMode(String path) {
        return this.deleteTrashMode(new File(path));
    }

    private boolean deleteTrashMode(File f) {
        if (!f.exists()) {
            return false;
        }
        String trash = this.getTrashPath();
        if (trash == null) {
            return false;
        }
        boolean result = false;
        try {
            String fileName;
            if (this.listener != null) {
                this.listener.publishFileName(String.valueOf(Confirm.resources.getString("MSG_DELETE_CONTINUE")) + f.getName());
            }
            if (!(fileName = this.getTrashFileName(f, new File(trash))).equals(f.getName())) {
                File newFile = new File(f.getParent(), fileName);
                result = f.renameTo(newFile);
                if (!result) {
                    return result;
                }
                f = newFile;
            }
            FileUtils.moveToDirectory((File)f, (File)new File(trash), (boolean)false);
            FileUtils.deleteQuietly((File)f);
            result = true;
        }
        catch (IOException e) {
            result = false;
        }
        return result;
    }

    public void run(AbstractProgressListener listener) {
        this.listener = listener;
        this.run();
    }

    public void run() {
        this.allSize = this.getAllSize();
        long totalSize = 0L;
        if (this.listener != null) {
            this.listener.publishProgress(0);
        }
        if (this.deleteMode == -1 || this.fileList == null || this.fileList.size() == 0) {
            return;
        }
        boolean result = false;
        Iterator<String> iterator = this.fileList.iterator();
        while (iterator.hasNext()) {
            String fName;
            this.currentFileName = fName = iterator.next();
            File f = new File(fName);
            if (f.exists() && f.isFile()) {
                this.progress = (int)((totalSize += f.length()) * 100L / this.allSize);
            }
            if (this.listener != null) {
                this.listener.publishFileName(String.valueOf(ResourceBundle.getBundle("org.hibara.attachecase.resource").getString("MSG_DELETE_CONTINUE")) + f.getName());
            }
            switch (this.deleteMode) {
                case 2: {
                    result = this.deleteTrashMode(fName);
                    break;
                }
                case 0: {
                    result = this.deleteNormalMode(fName);
                    break;
                }
                default: {
                    result = this.deleteThoroughMode(fName);
                    result = this.deleteNormalMode(fName);
                }
            }
            if (!result) break;
            if (this.listener == null || !this.listener.isCancel()) continue;
            return;
        }
    }

    private void deleteByRandomData(RandomAccessFile f) throws IOException {
        long size = f.length();
        int i = 0;
        while (i < this.randomCount) {
            f.seek(0L);
            long count = size;
            while (count > 0L) {
                byte[] buffer = this.getRandomByteArray((int)(count >= 1024L ? 1024L : count));
                f.write(buffer);
                count -= 1024L;
            }
            ++i;
        }
    }

    private byte[] getRandomByteArray(int length) {
        byte[] buffer = new byte[length];
        int i = 0;
        while (i < length) {
            buffer[i] = (byte)(Math.random() * 256.0);
            ++i;
        }
        return buffer;
    }

    private void deleteByZeroData(RandomAccessFile f) throws IOException {
        long size = f.length();
        byte[] buffer = new byte[1024];
        int i = 0;
        while (i < this.zeroCount) {
            f.seek(0L);
            long count = size;
            while (count > 0L) {
                f.write(buffer, 0, (int)(count >= 1024L ? 1024L : count));
                count -= 1024L;
            }
            ++i;
        }
    }

    private String getTrashFileName(File file, File trash) {
        File dir = file.getParentFile();
        File f1 = new File(trash, file.getName());
        if (!f1.exists()) {
            return file.getName();
        }
        File f2 = new File(dir, file.getName());
        int count = 0;
        NumberFormat nf = NumberFormat.getInstance();
        nf.setParseIntegerOnly(true);
        nf.setGroupingUsed(false);
        nf.setMinimumIntegerDigits(5);
        while (f1.exists() || f2.exists()) {
            String fileName = String.valueOf(FilenameUtils.getBaseName((String)file.getName())) + "_" + nf.format(++count) + "." + FilenameUtils.getExtension((String)file.getName());
            f1 = new File(trash, fileName);
            f2 = new File(dir, fileName);
        }
        return f2.getName();
    }

    private long getAllSize() {
        long size = 0L;
        for (String s : this.fileList) {
            File f = new File(s);
            if (!f.exists() || !f.isFile()) continue;
            size += f.length();
        }
        return size;
    }
}

