/*
 * Decompiled with CFR 0.152.
 */
package org.hibara.attachecase.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class IconButton
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = 1L;
    private BufferedImage mouseOutImage;
    private BufferedImage mouseOverImage;
    private boolean mouse_enter;

    public IconButton() {
        Dimension dim = new Dimension(48, 48);
        this.setPreferredSize(dim);
        this.setMaximumSize(dim);
        this.setMinimumSize(dim);
        this.setEnabled(true);
        this.addMouseListener(this);
        this.setBackground(Color.WHITE);
        this.mouse_enter = false;
    }

    public IconButton(String path1, String path2) {
        this();
        try {
            URL url1 = this.getClass().getResource(path1);
            URL url2 = this.getClass().getResource(path2);
            this.mouseOutImage = ImageIO.read(url1);
            this.mouseOverImage = ImageIO.read(url2);
            Dimension dim = new Dimension(this.mouseOutImage.getHeight(), this.mouseOutImage.getWidth());
            this.setPreferredSize(dim);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.mouse_enter) {
            g.drawImage(this.mouseOverImage, 0, 0, this);
        } else {
            g.drawImage(this.mouseOutImage, 0, 0, this);
        }
        g.dispose();
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
        this.mouse_enter = true;
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
        this.mouse_enter = false;
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    public void setDrop(DropTargetAdapter adaptor) {
        if (adaptor == null) {
            return;
        }
        new DropTarget(this, adaptor);
    }
}

