/*
 * Decompiled with CFR 0.152.
 */
package org.hibara.attachecase.entity;

import java.io.IOException;
import org.hibara.attachecase.AttacheCaseConstant;
import org.hibara.attachecase.exception.FileDestroyedException;
import org.hibara.attachecase.exception.NotEncryptFileException;
import org.hibara.attachecase.io.RandomAccessFile;

public class InfoTable
implements AttacheCaseConstant {
    private RandomAccessFile fs;
    private int planeHeaderSize;
    private int encryptHeaderSize;
    private byte[] token = new byte[16];
    private int dataVersion;
    private int algorismType;
    private long allTotalSize;
    private long totalSize;
    private int typeLimits;
    private boolean fileDestory;
    private byte[] randomSalt = new byte[8];
    private boolean executable = false;
    private boolean broken = false;
    private boolean existToken = false;
    private long headerTop = 0L;
    private long lastPointer = 0L;
    private int appVersion = 0;

    public InfoTable(RandomAccessFile fs) throws Exception {
        this.fs = fs;
        if (fs != null) {
            long currentPointer = fs.getFilePointer();
            fs.seekFromEnd(0L);
            this.lastPointer = fs.getFilePointer();
            fs.seek(currentPointer);
            this.checkFile(fs);
            fs.seek(currentPointer);
        }
    }

    public int getTypeLimits() {
        return this.typeLimits;
    }

    public int getPlaneHeaderSize() {
        return this.planeHeaderSize;
    }

    public void setPlaneHeaderSize(int planeHeaderSize) {
        this.planeHeaderSize = planeHeaderSize;
    }

    public int getEncryptHeaderSize() {
        return this.encryptHeaderSize;
    }

    public void setEncryptHeaderSize(int encryptHeaderSize) {
        this.encryptHeaderSize = encryptHeaderSize;
    }

    public byte[] getToken() {
        return this.token;
    }

    public void setToken(byte[] token) {
        this.token = token;
    }

    public int getDataVersion() {
        return this.dataVersion;
    }

    public void setDataVersion(int dataVersion) {
        this.dataVersion = dataVersion;
    }

    public int getAlgorismType() {
        return this.algorismType;
    }

    public void setAlgorismType(int algorismType) {
        this.algorismType = algorismType;
    }

    public long getAllTotalSize() {
        return this.allTotalSize;
    }

    public void setAllTotalSize(long allTotalSize) {
        this.allTotalSize = allTotalSize;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public void setTotalSize(long totalSize) {
        this.totalSize = totalSize;
    }

    public boolean isMatchToken() {
        return this.existToken;
    }

    public boolean isMatchToken(String str) {
        if (str == null || str.length() != this.token.length) {
            return false;
        }
        boolean match = true;
        int i = 0;
        while (i < this.token.length) {
            byte ch = this.token[i];
            if (str.charAt(i) != (char)ch) {
                match = false;
                break;
            }
            ++i;
        }
        return match;
    }

    public void readFromFile() throws Exception {
        if (!this.existToken) {
            throw new NotEncryptFileException();
        }
        if (this.broken) {
            throw new FileDestroyedException();
        }
        this.fs.seek(this.headerTop);
        long work = this.fs.readIntFromByte();
        if (work > Integer.MAX_VALUE) {
            throw new NotEncryptFileException();
        }
        this.planeHeaderSize = (int)work;
        this.fs.read(this.token);
        work = this.fs.readIntFromByte();
        if (work > Integer.MAX_VALUE) {
            throw new NotEncryptFileException();
        }
        this.dataVersion = (int)work;
        if (work < 130L) {
            this.readFromVersion2();
        } else if (work >= 130L && this.dataVersion < 200) {
            this.readFromVersion3();
        }
    }

    private void readFromVersion3() throws NotEncryptFileException, IOException {
        long work = this.fs.readIntFromByte();
        if (work > Integer.MAX_VALUE) {
            throw new NotEncryptFileException();
        }
        this.encryptHeaderSize = (int)work;
        this.fs.read(this.randomSalt, 0, 8);
        this.typeLimits = this.getTypeLimits();
        this.fileDestory = this.getDestoryFlagFromPlaneHeaderSize();
        if (this.typeLimits < 1 || this.typeLimits > 10) {
            this.typeLimits = 3;
        }
        this.getAppVersion();
    }

    private int getAppVersion() {
        this.appVersion = this.planeHeaderSize & 0xFFFF;
        return this.appVersion;
    }

    private void readFromVersion2() throws NotEncryptFileException, IOException {
        this.algorismType = (int)this.fs.readIntFromByte();
        long work = this.fs.readIntFromByte();
        if (work > Integer.MAX_VALUE) {
            throw new NotEncryptFileException();
        }
        this.encryptHeaderSize = (int)work;
        if (this.getDataSubversionFromPlaneHeaderSize() == 6) {
            this.typeLimits = this.getTypeLimits();
            this.fileDestory = this.getDestoryFlagFromPlaneHeaderSize();
            if (this.typeLimits < 1 || this.typeLimits > 10) {
                this.typeLimits = 3;
            }
        } else {
            this.typeLimits = 3;
            this.fileDestory = false;
        }
    }

    private void checkFile(RandomAccessFile fs) throws IOException {
        byte data = fs.readByte();
        byte[] token = "_AttacheCaseData".getBytes();
        byte[] brokenToken = "_Atc_Broken_Data".getBytes();
        while (true) {
            long filePointer;
            int i;
            if (data == token[0]) {
                this.existToken = true;
                i = 1;
                while (i < token.length) {
                    data = fs.readByte();
                    if (data != token[i]) {
                        this.existToken = false;
                        break;
                    }
                    ++i;
                }
                if (this.existToken) {
                    if (fs.getFilePointer() <= 20L) break;
                    this.executable = true;
                    this.headerTop = fs.getFilePointer() - 20L;
                    break;
                }
            }
            if (!this.existToken && data == brokenToken[0]) {
                this.existToken = true;
                i = 1;
                while (i < brokenToken.length) {
                    data = fs.readByte();
                    if (data != brokenToken[i]) {
                        this.existToken = false;
                        break;
                    }
                    ++i;
                }
                if (this.existToken) {
                    if (fs.getFilePointer() > 20L) {
                        this.executable = true;
                        this.headerTop = fs.getFilePointer() - 20L;
                    }
                    this.broken = true;
                }
            }
            if ((filePointer = fs.getFilePointer()) > 512L && filePointer < 13824L) {
                if (this.lastPointer <= 221184L) break;
                fs.seek(221184L);
            } else if (filePointer >= 225280L && filePointer < 521728L) {
                if (this.lastPointer <= 521728L) break;
                fs.seek(521728L);
            } else if (filePointer > 524288L) break;
            data = fs.readByte();
        }
    }

    @Deprecated
    public void readFromFile(RandomAccessFile fs) throws IOException {
        if (fs == null) {
            return;
        }
        this.planeHeaderSize = (int)fs.readIntFromByte();
        fs.read(this.token);
        if (!this.isMatchToken()) {
            fs.seekFromEnd(-8L);
            this.allTotalSize = fs.readLongFromByte();
            fs.seekFromEnd(-(this.allTotalSize + 8L));
            this.planeHeaderSize = (int)fs.readIntFromByte();
            fs.read(this.token);
        }
        this.dataVersion = (int)fs.readIntFromByte();
        this.algorismType = (int)fs.readIntFromByte();
        this.encryptHeaderSize = (int)fs.readIntFromByte();
        if (this.getDataSubversionFromPlaneHeaderSize() == 6) {
            this.typeLimits = this.getTypeLimitsFromPlaneHeaderSize();
            this.fileDestory = this.getDestoryFlagFromPlaneHeaderSize();
            if (this.typeLimits < 1 || 10 < this.typeLimits) {
                this.typeLimits = 3;
            }
        } else {
            this.typeLimits = 3;
            this.fileDestory = false;
        }
    }

    public boolean isFileDestroy() {
        return this.fileDestory;
    }

    public void setFileDestroy(boolean fDestroy) {
        this.fileDestory = fDestroy;
    }

    public void setTypeLimits(int typeLimits) {
        this.typeLimits = typeLimits;
    }

    private int getTypeLimitsFromPlaneHeaderSize() {
        int work = this.planeHeaderSize & 0xFF0000;
        work = work >>> 16 & 0xFF;
        return work;
    }

    public int getDataSubversionFromPlaneHeaderSize() {
        int work = this.planeHeaderSize & 0xFF;
        return work;
    }

    private boolean getDestoryFlagFromPlaneHeaderSize() {
        int work = this.planeHeaderSize & 0xFF000000;
        return (work = work >>> 24 & 0xFF) != 0;
    }

    public boolean isExecutable() {
        return this.executable;
    }

    public void setExecutable(boolean executable) {
        this.executable = executable;
    }

    public boolean isExistToken() {
        return this.existToken;
    }

    public void setExistToken(boolean existToken) {
        this.existToken = existToken;
    }

    public byte[] getRandomSalt() {
        return this.randomSalt;
    }

    public long getHeaderTop() {
        return this.headerTop;
    }
}

