/*
 * Decompiled with CFR 0.152.
 */
package org.hibara.attachecase.entity;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibara.attachecase.entity.FileAttribute;

public class FileInformation {
    protected String header;
    protected String atcFileCreateDateString;
    protected List<FileAttribute> files;
    protected int size = 0;

    public FileInformation() {
        this.header = null;
        this.atcFileCreateDateString = null;
        this.files = new ArrayList<FileAttribute>();
    }

    public FileInformation(List<String> list) {
        try {
            FileAttribute attr;
            String str;
            this.header = list.get(0);
            this.atcFileCreateDateString = list.get(1);
            this.files = new ArrayList<FileAttribute>();
            int i = 2;
            while (i < list.size()) {
                str = list.get(i);
                if (str.startsWith("Fn_")) {
                    attr = new FileAttribute(str);
                    this.files.add(attr);
                }
                ++i;
            }
            if (this.files.size() == 0) {
                i = 2;
                while (i < list.size()) {
                    str = list.get(i);
                    if (str.startsWith("U_")) {
                        str = new String(str.getBytes("Windows-31J"));
                        attr = new FileAttribute(str);
                        this.files.add(attr);
                    }
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String getAtcFileCreateDateString() {
        return this.atcFileCreateDateString;
    }

    public void setAtcFileCreateDateString(String atcFileCreateDateString) {
        this.atcFileCreateDateString = atcFileCreateDateString;
    }

    public List<FileAttribute> getFiles() {
        return this.files;
    }

    public void setFiles(List<FileAttribute> files) {
        this.files = files;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getFileListSize() {
        return this.files.size();
    }

    public long getAtcFileCreateDate() {
        long timestamp = 0L;
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        String dateString = this.atcFileCreateDateString.substring(this.atcFileCreateDateString.indexOf(58) + 1);
        try {
            Date date = df.parse(dateString);
            timestamp = date.getTime();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return timestamp;
    }

    public long getAllTotalSize() {
        long size = 0L;
        for (FileAttribute attr : this.files) {
            if (attr.getFileSize() == -1L) continue;
            size += attr.getFileSize();
        }
        return size;
    }
}

