/*
 * Decompiled with CFR 0.152.
 */
package org.hibara.attachecase.entity;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.hibara.attachecase.entity.FileAttribute;
import org.hibara.attachecase.utility.Digest;
import org.hibara.attachecase.utility.Utility;

public class FileAttribute3
extends FileAttribute {
    public static final String FILE_SEPARATER = "" + File.separatorChar;

    public FileAttribute3() {
    }

    public FileAttribute3(String s) {
        super(s);
    }

    @Override
    public boolean isDirectory() {
        return this.fileName.endsWith(FILE_SEPARATER) && this.fileSize == 0L;
    }

    public void setDirectory() {
        this.fileSize = 0L;
        if (!this.fileName.endsWith(FILE_SEPARATER)) {
            this.fileName = String.valueOf(this.fileName) + FILE_SEPARATER;
        }
    }

    @Override
    public void setModifyedTimeStamp(long date) {
        double[] dateAndTime = this.calcTimeStamp(date);
        this.modifiedDate = (int)dateAndTime[0];
        this.modifiedTime = dateAndTime[1];
    }

    @Override
    public void setCreateTimeStamp(long date) {
        double[] dateAndTime = this.calcTimeStamp(date);
        this.createDate = (int)dateAndTime[0];
        this.createTime = dateAndTime[1];
    }

    private double[] calcTimeStamp(long date) {
        Date d = new Date(date);
        double[] dateAndTime = new double[]{0.0, 0.0};
        try {
            double day;
            SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd");
            String dayOnlyStr = df.format(d);
            Date dayOnly = df.parse(dayOnlyStr);
            double time = (double)(date - dayOnly.getTime()) / 1000.0;
            dateAndTime[0] = day = (double)(dayOnly.getTime() / 86400000L - Utility.get00010101Time() / 86400000L - 1L);
            dateAndTime[1] = time;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dateAndTime;
    }

    @Override
    public String getAttributeByString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.index);
        sb.append(':');
        String name = this.getFileNameOnly();
        File f = new File(name);
        name = name.replace(File.separatorChar, '\\');
        if (this.base != null) {
            this.base = this.base.replace(File.separatorChar, '\\');
        }
        if (this.base != null) {
            String baseWithOutDrive = "";
            baseWithOutDrive = Utility.isWindows() && this.base.indexOf(58) != -1 ? this.base.substring(this.base.indexOf(58) + 1) : this.base;
            if (name.startsWith(baseWithOutDrive)) {
                name = name.substring(baseWithOutDrive.length());
            }
        }
        if (f.isAbsolute()) {
            if (Utility.isWindows()) {
                int pos = name.indexOf(92, 0);
                while (name.charAt(pos + 1) == '\\') {
                    pos = name.indexOf(92, pos + 1);
                }
                name = name.substring(pos + 1);
            } else {
                name = name.substring(name.indexOf(47) + 1);
            }
        } else if (name.startsWith("..\\")) {
            name = name.substring(3);
        } else if (name.startsWith(".\\")) {
            name = name.substring(2);
        }
        sb.append(name);
        if (this.isDirectory()) {
            sb.append("\t0\t");
        } else {
            sb.append('\t');
            sb.append(this.fileSize);
            sb.append('\t');
        }
        sb.append(this.isDirectory() ? 48 : this.attribute & 0x20);
        sb.append('\t');
        sb.append((int)this.modifiedDate);
        sb.append('\t');
        sb.append(this.modifiedTime);
        sb.append('\t');
        sb.append((int)this.createDate);
        sb.append('\t');
        sb.append(this.createTime);
        if (this.isDirectory()) {
            return sb.toString();
        }
        sb.append('\t');
        Digest digest = new Digest();
        this.checksum = digest.getSha256ByString(this.fileName);
        sb.append(this.checksum);
        return sb.toString();
    }
}

