/*
 * Decompiled with CFR 0.152.
 */
package org.hibara.attachecase.entity;

import java.io.File;
import java.util.TimeZone;
import org.hibara.attachecase.utility.Utility;

public class FileAttribute {
    protected String fileName;
    protected int attribute;
    protected double modifiedDate;
    protected double modifiedTime;
    protected double createDate;
    protected double createTime;
    protected long fileSize;
    protected int index;
    protected String suffix = "Fn_";
    protected String base;
    protected String checksum = "";

    public FileAttribute() {
    }

    public FileAttribute(String s) {
        String[] elements = s.split("\t");
        if (elements.length < 7) {
            return;
        }
        int i = 0;
        this.setFileName(elements[i++]);
        this.fileSize = this.parseInt(elements[i++]);
        this.attribute = this.parseInt(elements[i++]);
        this.modifiedDate = this.parseDouble(elements[i++]);
        this.modifiedTime = this.parseDouble(elements[i++]);
        this.createDate = this.parseDouble(elements[i++]);
        this.createTime = this.parseDouble(elements[i++]);
        if (elements.length > 7) {
            this.checksum = elements[i++];
        }
    }

    protected int parseInt(String s) {
        int value = 0;
        try {
            value = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            value = -1;
        }
        return value;
    }

    protected double parseDouble(String s) {
        double value = 0.0;
        try {
            value = Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            value = -1.0;
        }
        return value;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFileNameOnly() {
        int pos = this.fileName.indexOf(58);
        if (pos == -1) {
            return Utility.rejectPathTraversal(this.fileName);
        }
        if (pos == this.fileName.length() - 1) {
            return "";
        }
        return Utility.rejectPathTraversal(this.fileName.substring(pos + 1));
    }

    public void setFileName(String fileName) {
        this.fileName = fileName = fileName.replace('\\', File.separatorChar);
    }

    public int getAttribute() {
        return this.attribute;
    }

    public void setAttribute(int attribute) {
        this.attribute = attribute;
    }

    public double getModifiedDate() {
        return this.modifiedDate;
    }

    public void setModifiedDate(double modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public double getModifiedTime() {
        return this.modifiedTime;
    }

    public void setModifiedTime(double modifiedTime) {
        this.modifiedTime = modifiedTime;
    }

    public double getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(double createDate) {
        this.createDate = createDate;
    }

    public double getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(double createTime) {
        this.createTime = createTime;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public boolean isDirectory() {
        return this.fileSize == -1L;
    }

    public boolean isFolder() {
        return this.isDirectory();
    }

    public String getBase() {
        return this.base;
    }

    public void setBase(String base) {
        this.base = base;
    }

    public void setModifyedTimeStamp(long date) {
        TimeZone tz = TimeZone.getDefault();
        this.modifiedDate = (int)(((date -= 86400000L + (long)tz.getRawOffset()) - -62135802000000L) / 86400000L);
        this.modifiedTime = (int)((date - -62135802000000L) % 86400000L);
    }

    public void setCreateTimeStamp(long date) {
        TimeZone tz = TimeZone.getDefault();
        this.createDate = (int)(((date -= 86400000L + (long)tz.getRawOffset()) - -62135802000000L) / 86400000L);
        this.createTime = (int)((date - -62135802000000L) % 86400000L);
    }

    public String getAttributeByString() {
        StringBuilder sb = new StringBuilder();
        if (!this.fileName.startsWith("Fn_") && !this.fileName.startsWith("U_") && this.suffix != null) {
            sb.append(this.suffix);
        }
        sb.append(this.index);
        sb.append(':');
        String name = this.rejectPathTraversal(this.getFileNameOnly());
        if (!Utility.isWindows()) {
            name = name.replace(File.separatorChar, '\\');
            if (this.base != null) {
                this.base = this.base.replace(File.separatorChar, '\\');
            }
        }
        File f = new File(name);
        if (this.base != null) {
            String baseWithOutDrive = "";
            baseWithOutDrive = Utility.isWindows() && this.base.indexOf(58) != -1 ? this.base.substring(this.base.indexOf(58) + 1) : this.base;
            if (name.startsWith(baseWithOutDrive)) {
                name = name.substring(baseWithOutDrive.length());
            }
        }
        if (f.isAbsolute()) {
            if (Utility.isWindows()) {
                int pos = name.indexOf(92, 0);
                while (name.charAt(pos + 1) == '\\') {
                    pos = name.indexOf(92, pos + 1);
                }
                name = name.substring(pos + 1);
            } else {
                name = name.substring(name.indexOf(47) + 1);
            }
        } else if (name.startsWith("..\\")) {
            name = name.substring(3);
        } else if (name.startsWith(".\\")) {
            name = name.substring(2);
        }
        sb.append(name);
        if (this.isDirectory()) {
            sb.append("\\\t*\t");
        } else {
            sb.append('\t');
            sb.append(this.fileSize);
            sb.append('\t');
        }
        sb.append(this.isDirectory() ? 16 : this.attribute & 0x20);
        sb.append('\t');
        sb.append((int)this.modifiedDate);
        sb.append('\t');
        sb.append((int)this.modifiedTime);
        sb.append('\t');
        sb.append((int)this.createDate);
        sb.append('\t');
        sb.append((int)this.createTime);
        sb.append('\t');
        return sb.toString();
    }

    public String toString() {
        return this.getAttributeByString();
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getChecksum() {
        return this.checksum;
    }

    protected String rejectPathTraversal(String path) {
        while (path.startsWith("../") || path.startsWith("./")) {
            if (path.startsWith("../")) {
                path = path.substring("../".length());
                continue;
            }
            if (!path.startsWith("./")) continue;
            path = path.substring("./".length());
        }
        return path;
    }
}

