/*
 * Decompiled with CFR 0.152.
 */
package org.hibara.attachecase.entity;

import java.util.Iterator;
import java.util.LinkedList;

public class ByteBufferManager {
    private LinkedList<Byte> pool;
    private int maxLength = 32;
    private int totalLength = 0;

    public ByteBufferManager(int maxLength) {
        this.maxLength = maxLength;
        this.pool = new LinkedList();
    }

    public void add(byte[] data) {
        this.add(data, data.length);
        this.totalLength += data.length;
    }

    public void add(byte[] data, int length) {
        int i = 0;
        while (i < length) {
            this.pool.add(data[i]);
            ++i;
        }
        this.totalLength += length;
    }

    public int read(byte[] readBuffer) {
        int count = 0;
        Iterator it = this.pool.iterator();
        while (it.hasNext()) {
            readBuffer[count++] = (Byte)it.next();
            it.remove();
            if (count == this.maxLength) break;
        }
        return count;
    }

    public int read(byte[] readBuffer, int length) {
        int count = 0;
        Iterator it = this.pool.iterator();
        while (it.hasNext()) {
            readBuffer[count++] = (Byte)it.next();
            it.remove();
            if (count == this.maxLength || count == length) break;
        }
        return count;
    }

    public boolean isAvailable() {
        return this.pool.size() >= this.maxLength;
    }

    public boolean isFinished() {
        return this.pool.size() == 0;
    }

    public int getTotalLength() {
        return this.totalLength;
    }
}

