/*
 * Decompiled with CFR 0.152.
 */
package org.hibara.attachecase.encrypt;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.engines.RijndaelEngine;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;
import org.hibara.attachecase.Confirm;
import org.hibara.attachecase.ConsoleConfirm;
import org.hibara.attachecase.Options;
import org.hibara.attachecase.encrypt.FileEncrypt;
import org.hibara.attachecase.entity.ByteBufferManager;
import org.hibara.attachecase.entity.FileAttribute;
import org.hibara.attachecase.entity.FileAttribute3;
import org.hibara.attachecase.entity.ShaEntity;
import org.hibara.attachecase.exception.ProcessBreakException;
import org.hibara.attachecase.io.ByteArrayOutputStream;
import org.hibara.attachecase.io.ZipDeflateOutputStream;
import org.hibara.attachecase.utility.Digest;
import org.hibara.attachecase.utility.Utility;

public class FileEncrypt3
extends FileEncrypt {
    private int headerSizePosition = 0;
    private byte[] randomSalt = null;

    public FileEncrypt3(boolean createSuspended) {
        super(createSuspended, new Options(), new ConsoleConfirm());
    }

    public FileEncrypt3(boolean createSuspended, Options options) {
        super(createSuspended, options, new ConsoleConfirm());
    }

    public FileEncrypt3(boolean createSuspended, Options options, Confirm confirm) {
        super(createSuspended, options, confirm);
    }

    @Override
    protected ByteArrayOutputStream createHeader() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] header = new byte[]{-116, 12, (byte)this.options.getMaxMistake(), (byte)(this.options.isFileBrakeOption() ? 1 : 0)};
        try {
            os.write(header);
            os.write("_AttacheCaseData".getBytes());
            os.writeInt(130);
            this.headerSizePosition = os.size();
            os.writeInt(0);
            this.randomSalt = Utility.getRandomSalt(8);
            if (this.randomSalt.length == 8) {
                os.write(this.randomSalt);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return os;
    }

    @Override
    protected List<FileAttribute> getFileInfomation(File f, String parentPath) {
        ArrayList<FileAttribute> list = new ArrayList<FileAttribute>();
        if (f.isHidden() && !this.options.isIncludeHidden()) {
            return list;
        }
        FileAttribute3 attr = new FileAttribute3();
        if (parentPath != null) {
            attr.setBase(Utility.includeTrailingPathDelimiter(parentPath));
        }
        attr.setFileName(f.getPath());
        attr.setModifyedTimeStamp(f.lastModified());
        attr.setCreateTimeStamp(f.lastModified());
        if (f.isDirectory()) {
            attr.setDirectory();
        } else {
            attr.setFileSize(f.length());
        }
        int permission = 0;
        if (!f.canWrite()) {
            permission |= 1;
        }
        if (f.getName().startsWith(".") && !Utility.isWindows()) {
            permission |= 2;
        }
        attr.setAttribute(permission);
        list.add(attr);
        if (f.isDirectory()) {
            File[] files;
            File[] fileArray = files = f.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File dirFile = fileArray[n2];
                String name = dirFile.getName();
                if (name.compareTo(".") != 0 && name.compareTo("..") != 0) {
                    list.addAll(this.getFileInfomation(dirFile, parentPath));
                }
                ++n2;
            }
        }
        return list;
    }

    @Override
    protected void addFileList(ByteArrayOutputStream os, List<FileAttribute> list) throws Exception {
        this.blockCipher = new RijndaelEngine(256);
        SHA1Digest algorithm = new SHA1Digest();
        PKCS5S2ParametersGenerator gen = new PKCS5S2ParametersGenerator((org.bouncycastle.crypto.Digest)algorithm);
        gen.init(this.key, this.randomSalt, 1000);
        byte[] dk = ((KeyParameter)gen.generateDerivedParameters(512)).getKey();
        this.aesKey = Arrays.copyOfRange(dk, 0, 32);
        this.aesIV = Arrays.copyOfRange(dk, 32, 64);
        this.blockCipher.init(true, (CipherParameters)new KeyParameter(this.aesKey));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write("atc3\n".getBytes());
        for (FileAttribute attr : list) {
            try {
                String s = attr.toString();
                bos.write(s.getBytes("UTF-8"));
                bos.write(10);
            }
            catch (UnsupportedEncodingException s) {
            }
            catch (IOException s) {
                // empty catch block
            }
        }
        int pos = 0;
        byte[] data = bos.toByteArray();
        bos.close();
        byte[] buffer = new byte[32];
        byte[] outBuffer = new byte[32];
        byte[] chainBuffer = Arrays.copyOf(this.aesIV, this.aesIV.length);
        while (pos < data.length) {
            int length;
            int n = length = pos + 32 > data.length ? data.length - pos : 32;
            if (length < 32) {
                Arrays.fill(buffer, (byte)0);
                System.arraycopy(data, pos, buffer, 0, length);
            } else {
                System.arraycopy(data, pos, buffer, 0, length);
            }
            pos += 32;
            int i = 0;
            while (i < 32) {
                int n2 = i;
                buffer[n2] = (byte)(buffer[n2] ^ chainBuffer[i]);
                ++i;
            }
            this.blockCipher.processBlock(buffer, 0, outBuffer, 0);
            os.write(outBuffer);
            System.arraycopy(outBuffer, 0, chainBuffer, 0, 32);
            Arrays.fill(buffer, (byte)0);
        }
        os.writeIntToPosition(data.length, this.headerSizePosition);
    }

    /*
     * Loose catch block
     */
    @Override
    protected void writeToAtcFile(OutputStream os, List<FileAttribute> list) throws Exception {
        block38: {
            ZipDeflateOutputStream comp;
            block39: {
                long totalSize = 0L;
                this.blockCipher = new RijndaelEngine(256);
                this.blockCipher.init(true, (CipherParameters)new KeyParameter(this.aesKey));
                byte[] chainBuffer = Arrays.copyOf(this.aesIV, this.aesIV.length);
                byte[] encryptBuffer = new byte[32];
                ByteBufferManager compBufferManger = new ByteBufferManager(32);
                int length = 0;
                BufferedInputStream ios = null;
                FileAttribute attr = null;
                comp = null;
                try {
                    int j;
                    comp = new ZipDeflateOutputStream(this.options.getCompressRate(), true);
                    byte[] readBuffer = new byte[1024];
                    byte[] sourceBuffer = new byte[32];
                    int i = 0;
                    while (i < list.size()) {
                        attr = list.get(i);
                        if (!attr.isDirectory()) {
                            if (this.listener != null) {
                                this.listener.publishFileName(String.valueOf(Confirm.resources.getString("MSG_ENCRYPT_CONTINUE")) + attr.getFileNameOnly());
                                if (this.listener.isCancel()) {
                                    this.listener.publishFileName(Confirm.resources.getString("MSG_ENCRYPT_STOPPED"));
                                    throw new ProcessBreakException();
                                }
                            }
                            ios = new BufferedInputStream(new FileInputStream(attr.getFileNameOnly()));
                            while ((length = ios.read(readBuffer)) != -1) {
                                this.progress = (int)(100L * (totalSize += (long)length) / this.allTotalSize);
                                if (this.listener != null) {
                                    this.listener.publishProgress(this.progress);
                                }
                                comp.write(readBuffer, length);
                                while (comp.canRead()) {
                                    byte[] compressedData = comp.readAll();
                                    if (compressedData == null || compressedData.length == 0) continue;
                                    compBufferManger.add(compressedData);
                                }
                                while (compBufferManger.isAvailable()) {
                                    int count = compBufferManger.read(sourceBuffer);
                                    j = 0;
                                    while (j < count) {
                                        int n = j;
                                        sourceBuffer[n] = (byte)(sourceBuffer[n] ^ chainBuffer[j]);
                                        ++j;
                                    }
                                    this.blockCipher.processBlock(sourceBuffer, 0, encryptBuffer, 0);
                                    os.write(encryptBuffer);
                                    Arrays.fill(sourceBuffer, (byte)0);
                                    System.arraycopy(encryptBuffer, 0, chainBuffer, 0, count);
                                }
                            }
                            ios.close();
                            if (!this.silent) {
                                System.out.printf(ResourceBundle.getBundle("org.hibara.attachecase.resource").getString("MSG_ENCRYPT_FILE"), attr.getFileNameOnly());
                            }
                        }
                        ++i;
                    }
                    comp.finish();
                    while (comp.canRead()) {
                        byte[] compressedData = comp.readAll();
                        if (compressedData.length == 0) continue;
                        compBufferManger.add(compressedData);
                    }
                    while (!compBufferManger.isFinished()) {
                        int count = compBufferManger.read(sourceBuffer);
                        if (count < 32) {
                            byte padding = 0;
                            j = count;
                            while (j < 32) {
                                sourceBuffer[j] = padding;
                                ++j;
                            }
                        }
                        int j2 = 0;
                        while (j2 < 32) {
                            int n = j2;
                            sourceBuffer[n] = (byte)(sourceBuffer[n] ^ chainBuffer[j2]);
                            ++j2;
                        }
                        this.blockCipher.processBlock(sourceBuffer, 0, encryptBuffer, 0);
                        os.write(encryptBuffer);
                        System.arraycopy(encryptBuffer, 0, chainBuffer, 0, count);
                    }
                }
                catch (FileNotFoundException e) {
                    String s = String.valueOf(Confirm.resources.getString("MSG_ERROR_NOT_FILE_EXIST").replace('\n', ' ')) + Confirm.resources.getString("MSG_CONFIRM_CONTINUE");
                    Object[] obj = new Object[]{attr.getFileNameOnly()};
                    int result = this.confirm.confirmYesNo(Utility.replacePlaceHolder(s, obj), false);
                    if (result == -1) {
                        throw new Exception();
                    }
                    if (ios != null) {
                        try {
                            ios.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (comp != null) {
                        comp.close();
                    }
                    break block38;
                }
                catch (IOException iOException) {
                    if (ios != null) {
                        try {
                            ios.close();
                        }
                        catch (IOException iOException2) {
                            // empty catch block
                        }
                    }
                    if (comp != null) {
                        comp.close();
                    }
                    break block38;
                    catch (Throwable throwable) {
                        if (ios != null) {
                            try {
                                ios.close();
                            }
                            catch (IOException iOException3) {
                                // empty catch block
                            }
                        }
                        if (comp != null) {
                            comp.close();
                        }
                        throw throwable;
                    }
                }
                if (ios == null) break block39;
                try {
                    ios.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (comp != null) {
                comp.close();
            }
        }
        if (!this.silent) {
            this.confirm.showMessageByBundle("MSG_ENCRYPT_END");
        }
    }

    @Override
    public void setPassword(String password) {
        this.setPasswordByUTF8(password);
    }

    @Override
    public void setSha(ShaEntity sha) {
        Digest digest = new Digest();
        try {
            this.setPassword(digest.getSha256(this.options.getDecryptPasswordFileName()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

