/*
 * Decompiled with CFR 0.152.
 */
package org.hibara.attachecase.encrypt;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.zip.Deflater;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.commons.io.FilenameUtils;
import org.hibara.attachecase.Confirm;
import org.hibara.attachecase.ConsoleConfirm;
import org.hibara.attachecase.Options;
import org.hibara.attachecase.encrypt.Encrypt;
import org.hibara.attachecase.entity.ByteBufferManager;
import org.hibara.attachecase.entity.FileAttribute;
import org.hibara.attachecase.exception.ProcessBreakException;
import org.hibara.attachecase.io.ByteArrayOutputStream;
import org.hibara.attachecase.utility.Utility;

public class FileEncrypt
extends Encrypt {
    protected String encryptFileName;
    protected long allTotalSize;
    protected boolean overwirteYesToAll;

    public FileEncrypt(boolean createSuspended) {
        this(createSuspended, new Options(), new ConsoleConfirm());
    }

    public FileEncrypt(boolean createSuspended, Options options) {
        this(createSuspended, options, new ConsoleConfirm());
    }

    public FileEncrypt(boolean createSuspended, Options options, Confirm confirm) {
        this.setOptions(options);
        this.confirm = confirm;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     */
    protected void writeToAtcFile(OutputStream os, List<FileAttribute> list) throws Exception {
        block36: {
            long totalSize = 0L;
            this.blockCipher.reset();
            byte[] chainBuffer = this.getInitalizationVector();
            byte[] encryptBuffer = new byte[32];
            Deflater comp = new Deflater(this.options.getCompressRate(), false);
            ByteBufferManager readBufferManger = new ByteBufferManager(1024);
            ByteBufferManager compBufferManger = new ByteBufferManager(32);
            int length = 0;
            BufferedInputStream ios = null;
            FileAttribute attr = null;
            try {
                int count;
                int j;
                os.write(chainBuffer);
                byte[] readBuffer = new byte[1024];
                byte[] compBuffer = new byte[256];
                byte[] sourceBuffer = new byte[32];
                int i = 0;
                while (i < list.size()) {
                    attr = list.get(i);
                    if (!attr.isDirectory()) {
                        if (this.listener != null) {
                            this.listener.publishFileName(String.valueOf(Confirm.resources.getString("MSG_ENCRYPT_CONTINUE")) + attr.getFileNameOnly());
                            if (this.listener.isCancel()) {
                                this.listener.publishFileName(Confirm.resources.getString("MSG_ENCRYPT_STOPPED"));
                                throw new ProcessBreakException();
                            }
                        }
                        ios = new BufferedInputStream(new FileInputStream(attr.getFileNameOnly()));
                        while ((length = ios.read(readBuffer)) != -1) {
                            int count2;
                            this.progress = (int)(100L * (totalSize += (long)length) / this.allTotalSize);
                            if (this.listener != null) {
                                this.listener.publishProgress(this.progress);
                            }
                            readBufferManger.add(readBuffer, length);
                            while (readBufferManger.isAvailable()) {
                                readBufferManger.read(readBuffer);
                                comp.setInput(readBuffer);
                            }
                            while (!comp.finished()) {
                                count2 = comp.deflate(compBuffer);
                                if (count2 == 0) break;
                                compBufferManger.add(compBuffer, count2);
                            }
                            while (compBufferManger.isAvailable()) {
                                count2 = compBufferManger.read(sourceBuffer);
                                j = 0;
                                while (j < count2) {
                                    int n = j;
                                    sourceBuffer[n] = (byte)(sourceBuffer[n] ^ chainBuffer[j]);
                                    ++j;
                                }
                                this.blockCipher.processBlock(sourceBuffer, 0, encryptBuffer, 0);
                                os.write(encryptBuffer);
                                System.arraycopy(encryptBuffer, 0, chainBuffer, 0, count2);
                                Arrays.fill(sourceBuffer, (byte)0);
                            }
                        }
                        ios.close();
                        if (!this.silent) {
                            System.out.printf(ResourceBundle.getBundle("org.hibara.attachecase.resource").getString("MSG_ENCRYPT_FILE"), attr.getFileNameOnly());
                        }
                    }
                    ++i;
                }
                while (!readBufferManger.isFinished()) {
                    readBufferManger.read(readBuffer);
                    comp.setInput(readBuffer, 0, readBuffer.length);
                }
                comp.finish();
                while (!comp.finished()) {
                    count = comp.deflate(compBuffer);
                    compBufferManger.add(compBuffer, count);
                }
                while (!compBufferManger.isFinished()) {
                    count = compBufferManger.read(sourceBuffer);
                    if (count < 32) {
                        byte padding = (byte)(32 - count);
                        j = count;
                        while (j < 32) {
                            sourceBuffer[j] = padding;
                            ++j;
                        }
                    }
                    int j2 = 0;
                    while (j2 < 32) {
                        int n = j2;
                        sourceBuffer[n] = (byte)(sourceBuffer[n] ^ chainBuffer[j2]);
                        ++j2;
                    }
                    this.blockCipher.processBlock(sourceBuffer, 0, encryptBuffer, 0);
                    os.write(encryptBuffer);
                    System.arraycopy(encryptBuffer, 0, chainBuffer, 0, count);
                }
            }
            catch (FileNotFoundException e) {
                String s = String.valueOf(Confirm.resources.getString("MSG_ERROR_NOT_FILE_EXIST").replace('\n', ' ')) + Confirm.resources.getString("MSG_CONFIRM_CONTINUE");
                Object[] obj = new Object[]{attr.getFileNameOnly()};
                int result = this.confirm.confirmYesNo(Utility.replacePlaceHolder(s, obj), false);
                if (result == -1) {
                    throw new Exception();
                }
                if (ios != null) {
                    try {
                        ios.close();
                    }
                    catch (IOException iOException) {}
                }
                break block36;
            }
            catch (IOException iOException) {
                if (ios != null) {
                    try {
                        ios.close();
                    }
                    catch (IOException iOException2) {}
                }
                break block36;
                catch (Throwable throwable) {
                    if (ios != null) {
                        try {
                            ios.close();
                        }
                        catch (IOException iOException3) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
            if (ios == null) break block36;
            try {
                ios.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!this.silent) {
            this.confirm.showMessageByBundle("MSG_ENCRYPT_END");
        }
    }

    protected void addFileList(ByteArrayOutputStream os, List<FileAttribute> list) throws Exception {
        byte[] chainBuffer = this.getInitalizationVector();
        os.write(chainBuffer);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int i = 0;
        while (i < 1) {
            bos.write("Passcode:AttacheCase\n".getBytes());
            bos.write(Utility.getDateTime(new Date()).getBytes());
            bos.write(10);
            for (FileAttribute attr : list) {
                try {
                    if (i == 1) {
                        attr.setSuffix("U_");
                    }
                    String s = attr.toString();
                    bos.write(s.getBytes(i == 0 ? "Windows-31J" : "UTF-8"));
                    bos.write(13);
                    bos.write(10);
                }
                catch (UnsupportedEncodingException s) {
                }
                catch (IOException s) {
                    // empty catch block
                }
            }
            ++i;
        }
        int pos = 0;
        int headerSize = 0;
        byte[] data = bos.toByteArray();
        bos.close();
        byte[] buffer = new byte[32];
        byte[] outBuffer = new byte[32];
        while (pos < data.length) {
            int length = pos + 32 > data.length ? data.length - pos : 32;
            System.arraycopy(data, pos, buffer, 0, length);
            if (length < 32) {
                int padding = 32 - length;
                Arrays.fill(buffer, (byte)padding);
                System.arraycopy(data, pos, buffer, 0, length);
            }
            pos += 32;
            int i2 = 0;
            while (i2 < 32) {
                int n = i2;
                buffer[n] = (byte)(buffer[n] ^ chainBuffer[i2]);
                ++i2;
            }
            this.blockCipher.processBlock(buffer, 0, outBuffer, 0);
            os.write(outBuffer);
            headerSize += 32;
            System.arraycopy(outBuffer, 0, chainBuffer, 0, 32);
            Arrays.fill(buffer, (byte)0);
        }
        os.writeHeaderSize(headerSize);
    }

    private byte[] getInitalizationVector() {
        byte[] buffer = null;
        try {
            KeyGenerator generator = KeyGenerator.getInstance("AES");
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            generator.init(256, random);
            SecretKey key = generator.generateKey();
            buffer = key.getEncoded();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return buffer;
    }

    protected List<List<FileAttribute>> getFileLists() {
        ArrayList<List<FileAttribute>> lists = new ArrayList<List<FileAttribute>>();
        ArrayList<FileAttribute> list = null;
        int i = 0;
        while (i < this.options.getEncryptFileNames().size()) {
            if (i == 0 || !this.options.isAllFilePacked()) {
                if (list != null) {
                    this.addIndexNumber(list);
                    lists.add(list);
                }
                list = new ArrayList<FileAttribute>();
            }
            File f = new File(this.options.getEncryptFileNames().get(i));
            list.addAll(this.getFileInfomation(f, f.getParent()));
            ++i;
        }
        if (list != null) {
            this.addIndexNumber(list);
        }
        lists.add(list);
        return lists;
    }

    private void addIndexNumber(List<FileAttribute> list) {
        int i = 0;
        while (i < list.size()) {
            list.get(i).setIndex(i);
            ++i;
        }
    }

    private void checkFileNotExist() throws ProcessBreakException {
        File f = new File(this.encryptFileName);
        if (!f.exists()) {
            return;
        }
        if (this.options.isConfirmOverwirte() && !this.overwirteYesToAll) {
            Object[] values = new Object[]{f.getAbsoluteFile()};
            String msg = Utility.replacePlaceHolder(ResourceBundle.getBundle("org.hibara.attachecase.resource").getString("MSG_CONFIRM_OVER_WRITE_SAME_FILE"), values);
            int result = this.confirm.confirmYesNoCancel(msg, false);
            switch (result) {
                case -2: {
                    throw new ProcessBreakException();
                }
                case 2: {
                    this.overwirteYesToAll = true;
                    break;
                }
                case -1: {
                    String anotherPath = this.confirm.inputFileName(f);
                    if (anotherPath == null) {
                        throw new ProcessBreakException();
                    }
                    this.encryptFileName = FilenameUtils.normalize((String)anotherPath);
                }
            }
        }
    }

    private String getEncryptFileName(List<FileAttribute> list) {
        if (list.size() == 0) {
            return null;
        }
        File f = new File(list.get(0).getFileNameOnly());
        String baseName = this.options.isIncludeExtension() ? f.getName() : FilenameUtils.getBaseName((String)f.getAbsolutePath());
        String extension = this.options.isCamouflageExtention() ? this.options.getExtensionString() : ".atc";
        File dir = f.getAbsoluteFile().getParentFile();
        String encodeFolder = this.options.getEncodeFolderPath();
        if (this.options.isEncodeToSameFolder() && encodeFolder != null && encodeFolder.length() != 0) {
            dir = new File(encodeFolder);
        }
        f = new File(dir, String.valueOf(baseName) + extension);
        return FilenameUtils.normalize((String)f.getAbsolutePath());
    }

    protected ByteArrayOutputStream createHeader() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        os.write(6);
        os.write(0);
        os.write(this.options.getMaxMistake());
        os.write(this.options.isFileBrakeOption() ? 1 : 0);
        try {
            os.write("_AttacheCaseData".getBytes("Windows-31J"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        os.writeInt(105);
        os.writeInt(1);
        os.writeHeaderSize(0);
        return os;
    }

    protected List<FileAttribute> getFileInfomation(File f, String parentPath) {
        ArrayList<FileAttribute> list = new ArrayList<FileAttribute>();
        if (f.isHidden() && !this.options.isIncludeHidden()) {
            return list;
        }
        FileAttribute attr = new FileAttribute();
        if (parentPath != null) {
            attr.setBase(Utility.includeTrailingPathDelimiter(parentPath));
        }
        if (f.isDirectory()) {
            attr.setFileSize(-1L);
        } else {
            attr.setFileSize(f.length());
        }
        attr.setFileName(f.getPath());
        attr.setModifyedTimeStamp(f.lastModified());
        attr.setCreateTimeStamp(f.lastModified());
        int permission = 0;
        if (!f.canWrite()) {
            permission |= 1;
        }
        if (f.getName().startsWith(".") && !Utility.isWindows()) {
            permission |= 2;
        }
        attr.setAttribute(permission);
        list.add(attr);
        if (f.isDirectory()) {
            File[] files;
            File[] fileArray = files = f.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File dirFile = fileArray[n2];
                String name = dirFile.getName();
                if (name.compareTo(".") != 0 && name.compareTo("..") != 0) {
                    list.addAll(this.getFileInfomation(dirFile, parentPath));
                }
                ++n2;
            }
        }
        return list;
    }

    private long getAllTotalSize(List<FileAttribute> list) {
        long size = 0L;
        for (FileAttribute attr : list) {
            if (attr.isDirectory()) continue;
            size += attr.getFileSize();
        }
        return size;
    }

    private boolean isExistMyself(List<FileAttribute> list, String encryptFileName) {
        boolean exist = false;
        for (FileAttribute attr : list) {
            if (!attr.getFileNameOnly().equals(encryptFileName)) continue;
            exist = true;
            break;
        }
        return exist;
    }
}

