/*
 * Decompiled with CFR 0.152.
 */
package org.hibara.attachecase.encrypt;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.apache.commons.io.FilenameUtils;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.RijndaelEngine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.hibara.attachecase.Confirm;
import org.hibara.attachecase.ConsoleConfirm;
import org.hibara.attachecase.Options;
import org.hibara.attachecase.encrypt.FileDecrypt2;
import org.hibara.attachecase.entity.Buffers;
import org.hibara.attachecase.entity.ByteBufferManager;
import org.hibara.attachecase.entity.FileAttribute;
import org.hibara.attachecase.entity.FileAttribute3;
import org.hibara.attachecase.entity.FileInformation;
import org.hibara.attachecase.exception.AttachecaseException;
import org.hibara.attachecase.exception.ChecksumErrorException;
import org.hibara.attachecase.exception.FileDestroyedException;
import org.hibara.attachecase.exception.PasswordException;
import org.hibara.attachecase.exception.ProcessBreakException;
import org.hibara.attachecase.io.RandomAccessFile;
import org.hibara.attachecase.utility.Digest;
import org.hibara.attachecase.utility.Utility;

public class FileDecrypt3
extends FileDecrypt2 {
    public FileDecrypt3(boolean createSuspended) {
        this(createSuspended, new Options(), new ConsoleConfirm());
    }

    public FileDecrypt3(boolean createSuspended, Options options) {
        this(createSuspended, options, new ConsoleConfirm());
    }

    public FileDecrypt3(boolean createSuspended, Options options, Confirm confirm) {
        super(createSuspended, options, confirm);
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[WHILELOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setPassword() throws IOException, PasswordException {
        if (this.options.isDecryptPasswordRequired() || this.failPasswordFile) {
            File f = new File(this.atcFilePath);
            String password = this.confirm.inputPassword(f.getName(), 1);
            if (password == null) {
                throw new PasswordException();
            }
            this.setPasswordByUTF8(password);
        } else if (this.options.isUsePasswordFile() && this.options.getDecryptPasswordFileName() != null && this.options.getDecryptPasswordFileName().length() > 0) {
            Digest digest = new Digest();
            this.setPassword(digest.getSha256(this.options.getDecryptPasswordFileName()));
        } else {
            this.setPasswordByUTF8(this.options.getDecryptPassword());
        }
    }

    private List<String> getFileNameList(RandomAccessFile fs) throws Exception {
        ArrayList<String> fileNames = new ArrayList<String>();
        int len = 0;
        byte[] chainBuffer = Arrays.copyOf(this.aesIV, this.aesIV.length);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        while (len < this.infoTable.getEncryptHeaderSize()) {
            byte[] sourceBuffer = new byte[32];
            len += fs.read(sourceBuffer);
            byte[] tempBuffer = (byte[])sourceBuffer.clone();
            byte[] outBuffer = new byte[32];
            this.blockCipher.processBlock(sourceBuffer, 0, outBuffer, 0);
            int i = 0;
            while (i < 32) {
                int n = i;
                outBuffer[n] = (byte)(outBuffer[n] ^ chainBuffer[i]);
                chainBuffer[i] = tempBuffer[i];
                ++i;
            }
            os.write(outBuffer);
        }
        byte[] header = Arrays.copyOfRange(os.toByteArray(), 0, this.infoTable.getEncryptHeaderSize());
        String fileNamesString = new String(header, "UTF-8");
        os.close();
        String[] stringArray = fileNamesString.split("(\n|\r)");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name.length() != 0) {
                fileNames.add(name);
            }
            ++n2;
        }
        return fileNames;
    }

    private boolean isSuccess(List<String> list) throws IOException {
        ++this.countOfTrials;
        boolean success = true;
        if (list == null || list.size() == 0 || list.get(0).indexOf("atc3") == -1) {
            success = false;
            if (this.infoTable.isFileDestroy() && this.countOfTrials >= this.infoTable.getTypeLimits()) {
                this.fsIn.seek(this.infoTable.getHeaderTop() - 32L);
                this.fsIn.write("_Atc_Broken_Data".getBytes());
                this.fsIn.seek(this.infoTable.getHeaderTop() - 8L);
                this.fsIn.write(new byte[8]);
            }
        }
        return success;
    }

    /*
     * Could not resolve type clashes
     */
    @Override
    protected void decrypt(RandomAccessFile fs, FileInformation info) throws IOException, AttachecaseException {
        this.blockCipher = new RijndaelEngine(256);
        this.blockCipher.init(false, (CipherParameters)new KeyParameter(Arrays.copyOf(this.aesKey, this.aesKey.length)));
        Inflater decompresser = new Inflater(true);
        byte[] chainBuffer = Arrays.copyOf(this.aesIV, this.aesIV.length);
        byte[] sourceBuffer = new byte[32];
        byte[] decompBuffer = new byte[2048];
        byte[] writeBuffer = new byte[1024];
        long allTotalSize = fs.length() - fs.getFilePointer();
        long totalSize = 0L;
        String saveDirPath = this.getSavePath();
        this.makeSaveDir(saveDirPath);
        ArrayList<FileAttribute3> dirList = new ArrayList<FileAttribute3>();
        Buffers buffers = new Buffers(sourceBuffer, chainBuffer, totalSize, allTotalSize);
        ByteBufferManager expandBuffer = new ByteBufferManager(256);
        Iterator<FileAttribute> it = info.getFiles().iterator();
        FileAttribute3 attr = null;
        FilterOutputStream os = null;
        long writeLength = 0L;
        int errorCount = 0;
        String writeFileName = null;
        try {
            while (it.hasNext() || os != null) {
                File f;
                totalSize = this.inputBuffer(this.fsIn, buffers);
                if (totalSize == allTotalSize) {
                    ++errorCount;
                }
                this.progress = (int)(100L * totalSize / Math.max(allTotalSize, 1L));
                if (this.listener != null) {
                    this.listener.publishProgress(this.progress);
                    if (this.listener.isCancel()) {
                        throw new ProcessBreakException();
                    }
                }
                if (buffers.getLength() >= 0) {
                    decompresser.setInput(buffers.getSourceBuffer(), 0, buffers.getLength());
                    while (!decompresser.finished()) {
                        try {
                            int count = decompresser.inflate(decompBuffer);
                            if (count == 0) break;
                            expandBuffer.add(decompBuffer, count);
                        }
                        catch (DataFormatException ex) {
                            ex.printStackTrace();
                            throw new AttachecaseException();
                        }
                    }
                }
                if (os == null) {
                    int result;
                    String msg;
                    Object[] values;
                    attr = (FileAttribute3)it.next();
                    this.currentFileName = attr.getFileNameOnly();
                    if (this.listener != null) {
                        this.listener.publishFileName(String.valueOf(Confirm.resources.getString("MSG_DECRYPT_CONTINUE")) + this.currentFileName);
                    }
                    String fileName = String.valueOf(saveDirPath) + this.currentFileName;
                    f = new File(fileName);
                    if (attr.isDirectory()) {
                        if (f.exists() && this.options.isConfirmOverwirte() && !this.overwirteYesToAll) {
                            values = new Object[]{this.currentFileName};
                            msg = Utility.replacePlaceHolder(ResourceBundle.getBundle("org.hibara.attachecase.resource").getString("MSG_CONFIRM_OVER_WRITE_SAME_DIR"), values);
                            result = this.confirm.confirmYesNoAllCancel(msg, false);
                            switch (result) {
                                case -2: {
                                    throw new ProcessBreakException();
                                }
                                case 2: {
                                    this.overwirteYesToAll = true;
                                    break;
                                }
                                case -1: {
                                    saveDirPath = Utility.includeTrailingPathDelimiter(this.confirm.inputDirName(f.getParentFile()));
                                    fileName = String.valueOf(saveDirPath) + this.currentFileName;
                                    f = new File(fileName);
                                }
                            }
                        }
                        f.mkdirs();
                        if (this.options.isTimestampNow()) continue;
                        dirList.add(attr);
                        continue;
                    }
                    if (f.exists() && this.options.isConfirmOverwirte() && !this.overwirteYesToAll) {
                        values = new Object[]{this.currentFileName};
                        msg = Utility.replacePlaceHolder(ResourceBundle.getBundle("org.hibara.attachecase.resource").getString("MSG_CONFIRM_OVER_WRITE_SAME_FILE"), values);
                        result = this.confirm.confirmYesNoAllCancel(msg, false);
                        switch (result) {
                            case -2: {
                                throw new ProcessBreakException();
                            }
                            case 2: {
                                this.overwirteYesToAll = true;
                                break;
                            }
                            case -1: {
                                this.currentFileName = Utility.includeTrailingPathDelimiter(this.confirm.inputFileName(f));
                                if (new File(this.currentFileName).isAbsolute()) {
                                    fileName = this.currentFileName;
                                    break;
                                }
                                String fileName = String.valueOf(saveDirPath) + this.currentFileName;
                                fileName = FilenameUtils.normalize((String)fileName);
                            }
                        }
                    }
                    if (fileName.indexOf("../") != -1) {
                        throw new AttachecaseException();
                    }
                    os = new BufferedOutputStream(new FileOutputStream(fileName));
                    writeFileName = fileName;
                    writeLength = 0L;
                }
                while (!expandBuffer.isFinished()) {
                    int length = writeLength + 1024L < attr.getFileSize() ? 1024 : (int)(attr.getFileSize() - writeLength);
                    length = expandBuffer.read(writeBuffer, length);
                    ((BufferedOutputStream)os).write(writeBuffer, 0, length);
                    if ((writeLength += (long)length) >= attr.getFileSize()) {
                        os.close();
                        os = null;
                        f = new File(writeFileName);
                        if (f.exists() && !this.options.isTimestampNow()) {
                            Utility.setFileTimeStamp(writeFileName, attr, false);
                        }
                        Utility.setFileAttribute(writeFileName, attr);
                        String checksum = this.getChecksum(writeFileName);
                        if (!checksum.equals(attr.getChecksum())) {
                            throw new ChecksumErrorException();
                        }
                        if (this.silent) break;
                        System.out.printf(ResourceBundle.getBundle("org.hibara.attachecase.resource").getString("MSG_DECRYPT_FILE"), this.currentFileName);
                        break;
                    }
                    errorCount = 0;
                }
                if (errorCount <= 30) continue;
                throw new FileDestroyedException();
            }
            for (FileAttribute attribute : dirList) {
                String fileName = String.valueOf(saveDirPath) + attribute.getFileNameOnly();
                Utility.setFileTimeStamp(fileName, attribute, false);
                Utility.setFileAttribute(fileName, attribute);
            }
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String getChecksum(String path) {
        Digest digest = new Digest();
        return digest.getSha256ByString(path);
    }
}

