/*
 * Decompiled with CFR 0.152.
 */
package org.hibara.attachecase.encrypt;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.apache.commons.io.FilenameUtils;
import org.hibara.attachecase.Confirm;
import org.hibara.attachecase.ConsoleConfirm;
import org.hibara.attachecase.Options;
import org.hibara.attachecase.encrypt.Encrypt;
import org.hibara.attachecase.entity.Buffers;
import org.hibara.attachecase.entity.ByteBufferManager;
import org.hibara.attachecase.entity.FileAttribute;
import org.hibara.attachecase.entity.FileInformation;
import org.hibara.attachecase.entity.InfoTable;
import org.hibara.attachecase.entity.ShaEntity;
import org.hibara.attachecase.exception.AttachecaseException;
import org.hibara.attachecase.exception.FileDestroyedException;
import org.hibara.attachecase.exception.PasswordException;
import org.hibara.attachecase.exception.ProcessBreakException;
import org.hibara.attachecase.io.RandomAccessFile;
import org.hibara.attachecase.utility.Digest;
import org.hibara.attachecase.utility.Utility;

public class FileDecrypt2
extends Encrypt {
    protected static final boolean DEBUG = false;
    protected static int typeLimits = 0;
    protected RandomAccessFile fsIn;
    protected InfoTable infoTable;
    protected boolean overwirteYesToAll;
    protected int countOfTrials = 0;
    protected String atcFilePath;
    protected boolean compare;
    protected boolean failPasswordFile = false;

    public FileDecrypt2(boolean createSuspended) {
        this(createSuspended, new Options(), new ConsoleConfirm());
    }

    public FileDecrypt2(boolean createSuspended, Options options) {
        this(createSuspended, options, new ConsoleConfirm());
    }

    public FileDecrypt2(boolean createSuspended, Options options, Confirm confirm) {
        int i = 0;
        while (i < this.key.length) {
            this.key[i] = 0;
            ++i;
        }
        this.setOptions(options);
        this.confirm = confirm;
    }

    public static int getTypeLimits() {
        return typeLimits;
    }

    public static void setTypeLimits(int typeLimits) {
        FileDecrypt2.typeLimits = typeLimits;
    }

    public String getAtcFilePath() {
        return this.atcFilePath;
    }

    public void setAtcFilePath(String atcFilePath) {
        this.atcFilePath = atcFilePath;
    }

    protected void destroy() {
        try {
            if (this.fsIn != null) {
                this.fsIn.close();
                this.fsIn = null;
            }
        }
        catch (IOException e) {
            this.confirm.showErrorMessage(e.getMessage());
        }
    }

    protected void finalize() throws Throwable {
        this.destroy();
        super.finalize();
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [16[WHILELOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<String> getFileNameList(RandomAccessFile fs) throws IOException, InvalidKeyException {
        ArrayList<String> fileNames = new ArrayList<String>();
        int len = 0;
        byte[] chainBuffer = new byte[32];
        fs.read(chainBuffer);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        while (len < this.infoTable.getEncryptHeaderSize()) {
            byte[] sourceBuffer = new byte[32];
            len += fs.read(sourceBuffer);
            byte[] tempBuffer = (byte[])sourceBuffer.clone();
            byte[] outBuffer = new byte[32];
            this.blockCipher.processBlock(sourceBuffer, 0, outBuffer, 0);
            int i = 0;
            while (i < 32) {
                int n = i;
                outBuffer[n] = (byte)(outBuffer[n] ^ chainBuffer[i]);
                chainBuffer[i] = tempBuffer[i];
                ++i;
            }
            os.write(outBuffer);
        }
        String fileNamesString = new String(os.toByteArray(), "Windows-31J");
        os.close();
        String[] stringArray = fileNamesString.split("(\n|\r)");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name.length() != 0) {
                fileNames.add(name);
            }
            ++n2;
        }
        return fileNames;
    }

    private boolean isSuccess(List<String> list) throws IOException {
        ++this.countOfTrials;
        boolean success = true;
        if (list == null || list.size() == 0 || list.get(0).indexOf("AttacheCase") == -1) {
            success = false;
            if (this.infoTable.isFileDestroy() && this.countOfTrials >= this.infoTable.getTypeLimits()) {
                this.fsIn.write(new byte[32]);
                this.fsIn.seekFromCurrent(-60L);
                this.fsIn.write("_Atc_Broken_Data".getBytes());
            }
        }
        return success;
    }

    protected String getSavePath() {
        String path;
        String string = path = this.options != null ? this.options.getDecodeFolderPath() : null;
        if (this.options == null || !this.options.isDecodeToSameFolder() || path == null || path.length() == 0) {
            File f = new File(this.atcFilePath);
            path = f.getAbsoluteFile().getParent();
        }
        return Utility.includeTrailingPathDelimiter(FilenameUtils.normalize((String)path));
    }

    protected byte[] getKeyArray() {
        byte[] keys = Arrays.copyOf(this.key, this.key.length);
        return keys;
    }

    protected long inputBuffer(RandomAccessFile fs, Buffers buffers) throws IOException {
        long size = buffers.getTotalSize();
        buffers.clearSourceBuffer();
        if (fs == null) {
            buffers.setLength(0);
            return size;
        }
        if (size >= buffers.getAllTotalSize()) {
            buffers.setLength(0);
            return size;
        }
        byte[] sourceBuffer = buffers.getSourceBuffer();
        size += (long)this.fsIn.read(sourceBuffer);
        byte[] tempBuffer = (byte[])sourceBuffer.clone();
        byte[] outBuffer = new byte[32];
        this.blockCipher.processBlock(sourceBuffer, 0, outBuffer, 0);
        byte[] chainBuffer = buffers.getChainBuffer();
        int i = 0;
        while (i < 32) {
            sourceBuffer[i] = (byte)(outBuffer[i] ^ chainBuffer[i]);
            ++i;
        }
        buffers.setChainBuffer((byte[])tempBuffer.clone());
        int length = 32;
        if (size > buffers.getAllTotalSize()) {
            boolean pkcs = false;
            int paddingNum = sourceBuffer[31];
            int i2 = 0;
            while (i2 < paddingNum) {
                if (sourceBuffer[31 - i2] != paddingNum) {
                    pkcs = false;
                    break;
                }
                pkcs = true;
                ++i2;
            }
            if (pkcs) {
                length = 32 - paddingNum;
            }
        }
        buffers.setLength(length);
        buffers.setTotalSize(size);
        return size;
    }

    protected void decrypt(RandomAccessFile fs, FileInformation info) throws IOException, AttachecaseException {
        Inflater decompresser = new Inflater(false);
        byte[] chainBuffer = new byte[32];
        byte[] sourceBuffer = new byte[32];
        byte[] decompBuffer = new byte[2048];
        byte[] writeBuffer = new byte[1024];
        long allTotalSize = fs.length() - fs.getFilePointer();
        long totalSize = fs.read(chainBuffer);
        String saveDirPath = this.getSavePath();
        this.makeSaveDir(saveDirPath);
        ArrayList<FileAttribute> dirList = new ArrayList<FileAttribute>();
        Buffers buffers = new Buffers(sourceBuffer, chainBuffer, totalSize, allTotalSize);
        ByteBufferManager expandBuffer = new ByteBufferManager(256);
        Iterator<FileAttribute> it = info.getFiles().iterator();
        FileAttribute attr = null;
        FilterOutputStream os = null;
        long writeLength = 0L;
        int errorCount = 0;
        String writeFileName = null;
        try {
            while (it.hasNext() || os != null) {
                File f;
                totalSize = this.inputBuffer(this.fsIn, buffers);
                if (totalSize == allTotalSize) {
                    ++errorCount;
                }
                this.progress = (int)(100L * totalSize / allTotalSize);
                if (this.listener != null) {
                    this.listener.publishProgress(this.progress);
                    if (this.listener.isCancel()) {
                        throw new ProcessBreakException();
                    }
                }
                if (buffers.getLength() >= 0) {
                    decompresser.setInput(buffers.getSourceBuffer(), 0, buffers.getLength());
                    while (!decompresser.finished()) {
                        try {
                            int count = decompresser.inflate(decompBuffer);
                            if (count == 0) break;
                            expandBuffer.add(decompBuffer, count);
                        }
                        catch (DataFormatException count) {
                            // empty catch block
                        }
                    }
                }
                if (os == null) {
                    int result;
                    String msg;
                    Object[] values;
                    attr = it.next();
                    this.currentFileName = attr.getFileNameOnly();
                    if (this.listener != null) {
                        this.listener.publishFileName(String.valueOf(Confirm.resources.getString("MSG_DECRYPT_CONTINUE")) + this.currentFileName);
                    }
                    String fileName = String.valueOf(saveDirPath) + this.currentFileName;
                    f = new File(fileName);
                    if (attr.isDirectory()) {
                        if (f.exists() && this.options.isConfirmOverwirte() && !this.overwirteYesToAll) {
                            values = new Object[]{this.currentFileName};
                            msg = Utility.replacePlaceHolder(ResourceBundle.getBundle("org.hibara.attachecase.resource").getString("MSG_CONFIRM_OVER_WRITE_SAME_DIR"), values);
                            result = this.confirm.confirmYesNoAllCancel(msg, false);
                            switch (result) {
                                case -2: {
                                    throw new ProcessBreakException();
                                }
                                case 2: {
                                    this.overwirteYesToAll = true;
                                    break;
                                }
                                case -1: {
                                    saveDirPath = Utility.includeTrailingPathDelimiter(this.confirm.inputDirName(f.getParentFile()));
                                    fileName = String.valueOf(saveDirPath) + this.currentFileName;
                                    f = new File(fileName);
                                }
                            }
                        }
                        f.mkdirs();
                        if (this.options.isTimestampNow()) continue;
                        dirList.add(attr);
                        continue;
                    }
                    if (f.exists() && this.options.isConfirmOverwirte() && !this.overwirteYesToAll) {
                        values = new Object[]{this.currentFileName};
                        msg = Utility.replacePlaceHolder(ResourceBundle.getBundle("org.hibara.attachecase.resource").getString("MSG_CONFIRM_OVER_WRITE_SAME_FILE"), values);
                        result = this.confirm.confirmYesNoAllCancel(msg, false);
                        switch (result) {
                            case -2: {
                                throw new ProcessBreakException();
                            }
                            case 2: {
                                this.overwirteYesToAll = true;
                                break;
                            }
                            case -1: {
                                this.currentFileName = Utility.includeTrailingPathDelimiter(this.confirm.inputFileName(f));
                                if (new File(this.currentFileName).isAbsolute()) {
                                    fileName = this.currentFileName;
                                    break;
                                }
                                fileName = String.valueOf(saveDirPath) + this.currentFileName;
                                fileName = FilenameUtils.normalize((String)fileName);
                            }
                        }
                    }
                    if (fileName.indexOf("../") != -1) {
                        throw new AttachecaseException();
                    }
                    os = new BufferedOutputStream(new FileOutputStream(fileName));
                    writeFileName = fileName;
                    writeLength = 0L;
                }
                while (!expandBuffer.isFinished()) {
                    int length = writeLength + 1024L < attr.getFileSize() ? 1024 : (int)(attr.getFileSize() - writeLength);
                    length = expandBuffer.read(writeBuffer, length);
                    ((BufferedOutputStream)os).write(writeBuffer, 0, length);
                    if ((writeLength += (long)length) >= attr.getFileSize()) {
                        os.close();
                        os = null;
                        f = new File(writeFileName);
                        if (f.exists() && !this.options.isTimestampNow()) {
                            Utility.setFileTimeStamp(writeFileName, attr, false);
                        }
                        Utility.setFileAttribute(writeFileName, attr);
                        if (this.silent) break;
                        System.out.printf(ResourceBundle.getBundle("org.hibara.attachecase.resource").getString("MSG_DECRYPT_FILE"), this.currentFileName);
                        break;
                    }
                    errorCount = 0;
                }
                if (errorCount <= 30) continue;
                throw new FileDestroyedException();
            }
            for (FileAttribute attribute : dirList) {
                String fileName = String.valueOf(saveDirPath) + attribute.getFileNameOnly();
                Utility.setFileTimeStamp(fileName, attribute, false);
                Utility.setFileAttribute(fileName, attribute);
            }
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void makeSaveDir(String path) {
        File f = new File(path);
        if (f.exists()) {
            return;
        }
        f.mkdir();
    }

    private void setPassword() throws IOException, PasswordException {
        if (this.options.isDecryptPasswordRequired() || this.failPasswordFile) {
            File f = new File(this.atcFilePath);
            String password = this.confirm.inputPassword(f.getName(), 1);
            if (password == null) {
                throw new PasswordException();
            }
            this.setPassword(password);
        } else if (this.options.isUsePasswordFile() && this.options.getDecryptPasswordFileName() != null && this.options.getDecryptPasswordFileName().length() > 0) {
            Digest digest = new Digest();
            ShaEntity shaEntity = digest.getHash(this.options.getDecryptPasswordFileName());
            this.setSha(shaEntity);
        } else {
            this.setPassword(this.options.getDecryptPassword());
        }
    }
}

