/*
 * Decompiled with CFR 0.152.
 */
package org.hibara.attachecase.encrypt;

import java.io.UnsupportedEncodingException;
import org.bouncycastle.crypto.BlockCipher;
import org.hibara.attachecase.AttacheCaseConstant;
import org.hibara.attachecase.Confirm;
import org.hibara.attachecase.Options;
import org.hibara.attachecase.entity.ShaEntity;
import org.hibara.attachecase.utility.AbstractProgressListener;

public abstract class Encrypt
implements AttacheCaseConstant,
Runnable {
    protected AbstractProgressListener listener = null;
    protected boolean complete = false;
    protected Options options = null;
    protected byte[] key = new byte[32];
    protected byte[] oldKey = new byte[32];
    protected ShaEntity sha;
    protected int progress;
    protected String currentFileName;
    protected Confirm confirm;
    protected BlockCipher blockCipher = null;
    protected Object rijndaelKey = null;
    protected boolean silent = false;
    protected int sleepTime;
    protected byte[] aesKey = new byte[32];
    protected byte[] aesIV = new byte[32];

    public Confirm getConfirm() {
        return this.confirm;
    }

    public void setConfirm(Confirm confirm) {
        this.confirm = confirm;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setSha(ShaEntity sha) {
        this.sha = sha;
        int i = 0;
        while (i < this.key.length) {
            this.oldKey[i] = 0;
            this.key[i] = 0;
            ++i;
        }
        i = 0;
        while (i < 32) {
            this.key[i] = sha.getHashArray()[i];
            if (this.key[i] == 0) break;
            ++i;
        }
        i = 0;
        while (i < sha.getHashArray().length) {
            this.oldKey[i] = sha.getHashArray()[i];
            ++i;
        }
    }

    public void setPassword(String planePassword) {
        int i = 0;
        while (i < this.key.length) {
            this.key[i] = 0;
            this.oldKey[i] = 0;
            ++i;
        }
        try {
            byte[] password = planePassword.getBytes("Windows-31J");
            int len = this.key.length < password.length ? this.key.length : password.length;
            int i2 = 0;
            while (i2 < len) {
                this.oldKey[i2] = this.key[i2] = password[i2];
                ++i2;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void setPassword(byte[] hash) {
        int length = Math.min(hash.length, this.key.length);
        int i = 0;
        while (i < length) {
            this.key[i] = hash[i];
            ++i;
        }
    }

    public void setPasswordByUTF8(String planePassword) {
        int i = 0;
        while (i < this.key.length) {
            this.key[i] = 0;
            this.oldKey[i] = 0;
            ++i;
        }
        try {
            byte[] password = planePassword.getBytes("UTF-8");
            int len = this.key.length < password.length ? this.key.length : password.length;
            int i2 = 0;
            while (i2 < len) {
                this.oldKey[i2] = this.key[i2] = password[i2];
                ++i2;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public ShaEntity getSha() {
        return this.sha;
    }

    public void run(AbstractProgressListener listener) {
        this.listener = listener;
        this.run();
    }

    @Override
    public abstract void run();

    public int getProgress() {
        return this.progress;
    }

    public String getCurrentFileName() {
        return this.currentFileName;
    }

    public Options getOptions() {
        return this.options;
    }

    public void setOptions(Options options) {
        this.options = options;
        this.silent = this.options.isSilent() || !this.options.isCui();
    }

    protected char[] getKeyByCharArray() {
        char[] chars = new char[this.key.length];
        int i = 0;
        while (i < this.key.length) {
            chars[i] = (char)((short)this.key[i] & 0xFF);
            ++i;
        }
        return chars;
    }
}

