/*
 * Decompiled with CFR 0.152.
 */
package org.hibara.attachecase;

import com.jgoodies.binding.beans.Model;
import com.townleyenterprises.command.CommandListener;
import com.townleyenterprises.command.CommandOption;
import com.townleyenterprises.command.CommandParser;
import com.townleyenterprises.command.DefaultCommandListener;
import com.townleyenterprises.command.RepeatableCommandOption;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibara.attachecase.AttacheCaseConstant;
import org.hibara.attachecase.Confirm;
import org.hibara.attachecase.utility.Utility;
import org.ini4j.Wini;

public class Options
extends Model
implements AttacheCaseConstant,
Cloneable {
    private static final long serialVersionUID = 5622094508320788533L;
    private static ResourceBundle resources = Confirm.resources;
    private RepeatableCommandOption encryptOption = new RepeatableCommandOption("encrypt", 'e', resources.getString("HELP_ENCRYPT_OPTION"), resources.getString("HELP_ENCRYPT_MSG"), true, null){

        public void execute() throws Exception {
            Options.this.setEncryptFileNames(this.getArgs());
            if (Options.this.runMode == 0) {
                Options.this.runMode = 2;
            }
        }
    };
    private RepeatableCommandOption decryptOption = new RepeatableCommandOption("decrypt", 'd', resources.getString("HELP_DECRYPT_OPTION"), resources.getString("HELP_DECRYPT_MSG"), true, null){

        public void execute() throws Exception {
            Options.this.setDecryptFileNames(this.getArgs());
            Options.this.runMode = 1;
        }
    };
    private CommandOption passwordOption = new CommandOption("password", 'p', true, resources.getString("HELP_PASSWORD_OPTION"), resources.getString("HELP_PASSWORD_MSG"), true, null){

        public void execute() throws Exception {
            Options.this.setDecryptPassword(this.getArg());
            Options.this.setEncryptPassword(this.getArg());
            Options.this.encryptPasswordRequired = false;
            Options.this.decryptPasswordRequired = false;
            Options.this.usePasswordOption = true;
        }
    };
    private CommandOption passwordFileOption = new CommandOption("passwordfile", 'P', true, resources.getString("HELP_PASSWORD_FILE_OPTION"), resources.getString("HELP_PASSWORD_FILE_MSG"), true, null){

        public void execute() throws Exception {
            String string = this.getArg();
            Options.this.decryptPasswordFileName = string;
            Options.this.encryptPasswordFileName = string;
            Options.this.decryptPasswordRequired = false;
            Options.this.encryptPasswordRequired = false;
        }
    };
    private CommandOption deleteOption = new CommandOption("delete", 'D', true, resources.getString("HELP_DELETE_OPTION"), resources.getString("HELP_DELETE_MSG"), true, null){

        public void execute() throws Exception {
            String arg = this.getArg();
            try {
                int value = Integer.parseInt(arg);
                if (value >= -1 && value <= 2) {
                    Options.this.deleteMode = value;
                    Options.this.deleteEncryptoFile = true;
                    Options.this.deleteOriginalFile = true;
                }
            }
            catch (NumberFormatException e) {
                Options.this.deleteMode = -1;
                Options.this.deleteEncryptoFile = false;
                Options.this.deleteOriginalFile = false;
            }
        }
    };
    private CommandOption overwriteOption = new CommandOption("overwrite", 'o', false, resources.getString("HELP_OVERWRITE_OPTION"), resources.getString("HELP_OVERWRITE_MSG"), true, null){

        public void execute() throws Exception {
            Options.this.confirmOverwirte = false;
        }
    };
    private CommandOption randomOption = new CommandOption("random", 'R', true, resources.getString("HELP_RANDOM_OPTION"), resources.getString("HELP_RANDOM_MSG"), true, null){

        public void execute() throws Exception {
            String arg = this.getArg();
            if (arg == null || arg.length() == 0) {
                throw new Exception();
            }
            try {
                int value = Integer.parseInt(arg);
                Options.this.randomWriteCount = value > 0 ? value : 1;
            }
            catch (NumberFormatException e) {
                Options.this.randomWriteCount = 1;
                throw e;
            }
        }
    };
    private CommandOption zeroOption = new CommandOption("zero", 'Z', true, resources.getString("HELP_ZERO_OPTION"), resources.getString("HELP_ZERO_MSG"), true, null){

        public void execute() throws Exception {
            String arg = this.getArg();
            try {
                int value = Integer.parseInt(arg);
                Options.this.zeroWriteCount = value > 0 ? value : 1;
            }
            catch (NumberFormatException e) {
                Options.this.zeroWriteCount = 1;
            }
        }
    };
    private CommandOption cuiOption = new CommandOption("cui", 'c', false, resources.getString("HELP_CUI_OPTION"), resources.getString("HELP_CUI_MSG"), true, null){

        public void execute() throws Exception {
            Options.this.cui = true;
        }
    };
    private CommandOption versionOption = new CommandOption("version", 'v', false, resources.getString("HELP_VERSION_OPTION"), resources.getString("HELP_VERSION_MSG"), true, null){

        public void execute() throws Exception {
            Options.this.cui = true;
            Options.this.runMode = 3;
        }
    };
    private CommandOption useVersion2Option = new CommandOption("version2", '2', false, resources.getString("HELP_VERSION2_OPTION"), resources.getString("HELP_VERSION2_MSG"), true, null){

        public void execute() throws Exception {
            Options.this.cui = true;
            Options.this.useVersion2 = true;
        }
    };
    private CommandOption compressRateOption = new CommandOption("compress", 'C', true, resources.getString("HELP_COMPRESS_OPTION"), resources.getString("HELP_COMPRESS_MSG"), true, null){

        public void execute() throws Exception {
            String arg = this.getArg();
            try {
                int value = Integer.parseInt(arg);
                Options.this.compressRate = value >= 0 && value < 10 ? value : 6;
            }
            catch (NumberFormatException e) {
                Options.this.compressRate = 6;
            }
        }
    };
    private CommandOption silentOption = new CommandOption("silent", 's', false, resources.getString("HELP_SILENT_OPTION"), resources.getString("HELP_SILENT_MSG"), true, null){

        public void execute() throws Exception {
            Options.this.silent = true;
        }
    };
    private CommandOption hiddenIncludeOption = new CommandOption("hidden", 'h', false, resources.getString("HELP_HIDDEN_INCLUDE_OPTION"), resources.getString("HELP_HIDDEN_INCLUDE_MSG"), true, null){

        public void execute() throws Exception {
            Options.this.includeHidden = true;
        }
    };
    private CommandOption saveFolderOption = new CommandOption("saveTo", 'S', true, resources.getString("HELP_DESTINATION_FOLDER_OPTION"), resources.getString("HELP_DESTINATION_FOLDER_MSG"), true, null){

        public void execute() throws Exception {
            String arg = this.getArg();
            Options.this.encodeToSameFolder = true;
            Options.this.encodeFolderPath = arg;
        }
    };
    private CommandOption[] commandOptions = new CommandOption[]{this.encryptOption, this.decryptOption, this.passwordOption, this.passwordFileOption, this.deleteOption, this.overwriteOption, this.randomOption, this.zeroOption, this.cuiOption, this.versionOption, this.compressRateOption, this.silentOption, this.hiddenIncludeOption, this.saveFolderOption, this.useVersion2Option};
    private String appPath;
    private int versionNum;
    private boolean changed = false;
    private boolean usePasswordOption = false;
    private static String[] ENCRYPT_PROPERTIES = new String[]{"decryptPassword", "encryptPassword"};
    private static String[][] PROPERTIES = new String[][]{{"BASIC", "memoryEncryptPassword", "encryptPassword", "memoryDecryptPassword", "decryptPassword", "encryptWithoutConfirmation", "openDirectoryAfterDecrypt", "openFile", "quitAfterEncrypt", "alwaysOnTop", "showPassword", "askEncryptOrDecrypt", "notMulipleStarts", "includeHidden", "useVersion2"}, {"SAVE", "encodeToSameFolder", "encodeFolderPath", "decodeToSameFolder", "decodeFolderPath", "confirmOverwirte", "allFilePacked", "notMakeParentFolder", "keepTimestamp", "timestampNow", "includeExtension", "autoNameFormatText", "addFileName"}, {"DELETE", "deleteOriginalFile", "deleteEncryptoFile", "deleteMode", "randomWriteCount", "zeroWriteCount"}, {"ADVANCED", "usePasswordFile", "encryptPasswordFileName", "decryptPasswordFileName", "fileBrakeOption", "maxMistake", "camouflageExtention", "extensionString", "compressRate"}};
    private List<String> encryptFileNames = null;
    private List<String> decryptFileNames = null;
    private int runMode = 0;
    private boolean cui = false;
    private boolean silent = false;
    private boolean includeHidden = false;
    private boolean quitAfterEncrypt = true;
    private boolean alwaysOnTop = true;
    private boolean openDirectoryAfterDecrypt = false;
    private boolean askEncryptOrDecrypt = false;
    private boolean notMulipleStarts = true;
    private boolean showPassword = true;
    private boolean useVersion2 = false;
    private String encryptPassword;
    private String decryptPassword;
    private boolean memoryEncryptPassword = false;
    private boolean memoryDecryptPassword = false;
    private boolean encryptWithoutConfirmation = false;
    private boolean encryptPasswordRequired = true;
    private boolean decryptPasswordRequired = true;
    private boolean openFile = false;
    private boolean decodeToSameFolder = false;
    private String decodeFolderPath = null;
    private boolean encodeToSameFolder = false;
    private String encodeFolderPath = null;
    private boolean confirmOverwirte = true;
    private boolean timestampNow = false;
    private boolean keepTimestamp = true;
    private boolean allFilePacked = false;
    private boolean notMakeParentFolder = false;
    private boolean includeExtension = false;
    private boolean addFileName = false;
    private String autoNameFormatText;
    private boolean deleteOriginalFile = false;
    private boolean deleteEncryptoFile = false;
    private int deleteMode = -1;
    private int randomWriteCount = 1;
    private int zeroWriteCount = 1;
    private int compressRate = 6;
    private boolean usePasswordFile = false;
    private String encryptPasswordFileName = null;
    private String decryptPasswordFileName = null;
    private boolean fileBrakeOption = false;
    private int maxMistake = 3;
    private boolean camouflageExtention = false;
    private String extensionString = ".jpg";

    public Options() {
        this.addChangeListener();
        this.loadFromFile();
    }

    public Options(String[] args) {
        String[] largs;
        this.loadFromFile();
        CommandParser parser = new CommandParser("Attachecase");
        parser.setExitOnMissingArg(true, -1);
        parser.setAbortExecuteOnError(false);
        parser.addCommandListener((CommandListener)new DefaultCommandListener("options", this.commandOptions));
        parser.parse(args);
        String[] stringArray = largs = parser.getUnhandledArguments();
        int n = largs.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            System.err.println("Unknown command-line argument: " + s);
            ++n2;
        }
        if (largs.length > 0) {
            System.exit(1);
        }
        if (!this.validateOptions(args)) {
            System.exit(-1);
        }
        try {
            parser.executeCommands();
        }
        catch (Exception e) {
            System.exit(-1);
        }
        this.addChangeListener();
    }

    public void addChangeListener() {
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!Options.this.changed) {
                    Object oldValue = evt.getOldValue();
                    Object newValue = evt.getNewValue();
                    if (oldValue != null && newValue != null) {
                        Options.this.changed = !oldValue.equals(newValue);
                    } else if (oldValue == null && newValue == null) {
                        Options.this.changed = false;
                    } else {
                        Options.this.changed = true;
                    }
                }
            }
        });
    }

    public boolean isIncludeHidden() {
        return this.includeHidden;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public void setSilent(boolean silent) {
        boolean oldValue = this.silent;
        this.silent = silent;
        this.firePropertyChange("silent", oldValue, this.silent);
    }

    public boolean isIncludeExtension() {
        return this.includeExtension;
    }

    public void setIncludeExtension(boolean includeExtension) {
        boolean oldValue = this.includeExtension;
        this.includeExtension = includeExtension;
        this.firePropertyChange("includeExtension", oldValue, includeExtension);
    }

    public boolean isAllFilePacked() {
        return this.allFilePacked;
    }

    public void setAllFilePacked(boolean allFilePacked) {
        boolean oldValue = this.allFilePacked;
        this.allFilePacked = allFilePacked;
        this.firePropertyChange("allFilePacked", oldValue, this.allFilePacked);
    }

    public String getAutoNameFormatText() {
        return this.autoNameFormatText;
    }

    public void setAutoNameFormatText(String autoNameFormatText) {
        String oldValue = this.autoNameFormatText;
        this.autoNameFormatText = autoNameFormatText;
        this.firePropertyChange("autoNameFormatText", oldValue, this.autoNameFormatText);
    }

    public boolean isCamouflageExtention() {
        return this.camouflageExtention;
    }

    public void setCamouflageExtention(boolean camouflageExtention) {
        boolean oldValue = this.camouflageExtention;
        this.camouflageExtention = camouflageExtention;
        this.firePropertyChange("camouflageExtention", oldValue, this.camouflageExtention);
    }

    public String getExtensionString() {
        return this.extensionString;
    }

    public void setExtensionString(String extensionString) {
        String oldValue = this.extensionString;
        this.extensionString = extensionString;
        this.firePropertyChange("extensionString", oldValue, this.extensionString);
    }

    public int getCompressRate() {
        return this.compressRate;
    }

    public void setCompressRate(int compressRate) {
        if (compressRate < 0) {
            compressRate = 0;
        } else if (compressRate > 9) {
            compressRate = 9;
        }
        int oldValue = this.compressRate;
        this.compressRate = compressRate;
        this.firePropertyChange("compressRate", oldValue, this.compressRate);
    }

    public void setDecryptPasswardRequired(boolean passwardRequired) {
        boolean oldValue = this.decryptPasswordRequired;
        this.decryptPasswordRequired = passwardRequired;
        this.firePropertyChange("decryptPasswordRequired", oldValue, this.decryptPasswordRequired);
    }

    public void setEncryptPasswardRequired(boolean passwardRequired) {
        boolean oldValue = this.encryptPasswordRequired;
        this.encryptPasswordRequired = passwardRequired;
        this.firePropertyChange("encryptPasswordRequired", oldValue, this.encryptPasswordRequired);
    }

    public List<String> getEncryptFileNames() {
        return this.encryptFileNames;
    }

    public void setEncryptFileNames(List<String> fileNames) {
        this.encryptFileNames = fileNames;
    }

    public void setEncryptFilenames(String fileName) {
        if (this.encryptFileNames == null) {
            this.encryptFileNames = new ArrayList<String>();
        }
        if (fileName == null) {
            return;
        }
        this.encryptFileNames.add(fileName);
    }

    public void setDecryptFileNames(List<String> fileNames) {
        this.decryptFileNames = fileNames;
    }

    public void setDecryptFilenames(String fileName) {
        if (this.decryptFileNames == null) {
            this.decryptFileNames = new ArrayList<String>();
        }
        this.decryptFileNames.add(fileName);
    }

    public List<String> getDecryptFileNames() {
        return this.decryptFileNames;
    }

    public boolean isDeleteOriginalFile() {
        return this.deleteOriginalFile;
    }

    public void setDeleteOriginalFile(boolean deleteOriginalFile) {
        boolean oldValue = this.deleteOriginalFile;
        this.deleteOriginalFile = deleteOriginalFile;
        this.firePropertyChange("deleteOriginalFile", oldValue, this.deleteOriginalFile);
    }

    public boolean isDeleteEncryptoFile() {
        return this.deleteEncryptoFile;
    }

    public void setDeleteEncryptoFile(boolean deleteEncryptoFile) {
        boolean oldValue = this.deleteEncryptoFile;
        this.deleteEncryptoFile = deleteEncryptoFile;
        this.firePropertyChange("deleteEncryptoFile", oldValue, this.deleteEncryptoFile);
    }

    public boolean isTimestampNow() {
        return this.timestampNow;
    }

    public void setTimestampNow(boolean timestampNow) {
        boolean oldValue = this.timestampNow;
        this.timestampNow = timestampNow;
        this.firePropertyChange("timestampNow", oldValue, this.timestampNow);
    }

    public boolean isKeepTimestamp() {
        return this.keepTimestamp;
    }

    public void setKeepTimestamp(boolean keepTimeStamp) {
        boolean oldValue = this.keepTimestamp;
        this.keepTimestamp = keepTimeStamp;
        this.firePropertyChange("keepTimestamp", oldValue, this.keepTimestamp);
    }

    public boolean isConfirmOverwirte() {
        return this.confirmOverwirte;
    }

    public void setConfirmOverwirte(boolean confirmOverwirte) {
        boolean oldValue = this.confirmOverwirte;
        this.confirmOverwirte = confirmOverwirte;
        this.firePropertyChange("confirmOverwirte", oldValue, this.confirmOverwirte);
    }

    public boolean isOpenFile() {
        return this.openFile;
    }

    public void setOpenFile(boolean openFile) {
        boolean oldValue = this.openFile;
        this.openFile = openFile;
        this.firePropertyChange("openFile", oldValue, this.openFile);
    }

    public String getAppPath() {
        return this.appPath;
    }

    public void setAppPath(String appPath) {
        String oldValue = this.appPath;
        this.appPath = appPath;
        this.firePropertyChange("appPath", oldValue, this.appPath);
    }

    public int getVersionNum() {
        return this.versionNum;
    }

    public void setVersionNum(int versionNum) {
        int oldValue = this.versionNum;
        this.versionNum = versionNum;
        this.firePropertyChange("versionNum", oldValue, this.versionNum);
    }

    public String getEncryptPassword() {
        return this.encryptPassword;
    }

    public String getEncryptPasswordByEncryption() {
        if (this.encryptPassword == null) {
            return null;
        }
        return Utility.encrypt(Confirm.resources.getString("APP_FRAME_NAME"), this.encryptPassword);
    }

    public String getDecryptPassword() {
        return this.decryptPassword;
    }

    public String getDecryptPasswordByEncryption() {
        if (this.decryptPassword == null) {
            return null;
        }
        return Utility.encrypt(Confirm.resources.getString("APP_FRAME_NAME"), this.decryptPassword);
    }

    public void setEncryptPassword(String password) {
        if (password == null || password.length() == 0) {
            this.setEncryptPasswordToNull(password);
            this.encryptPasswordRequired = true;
            return;
        }
        String oldValue = this.encryptPassword;
        this.encryptPassword = password;
        this.encryptPasswordRequired = false;
        this.firePropertyChange("encryptPassword", oldValue, this.encryptPassword);
    }

    public void setEncryptPasswordToNull(String password) {
        String oldValue = this.encryptPassword;
        this.encryptPassword = password;
        this.firePropertyChange("encryptPassword", oldValue, this.encryptPassword);
    }

    public void setEncryptPasswordByEncryption(String encryptedPassword) {
        String password = Utility.decrypt(Confirm.resources.getString("APP_FRAME_NAME"), encryptedPassword);
        this.setEncryptPassword(password);
    }

    public void setDecryptPassword(String password) {
        if (password == null || password.length() == 0) {
            this.setDecryptPasswordToNull(password);
            this.setDecryptPasswordRequired(true);
            return;
        }
        String oldValue = this.decryptPassword;
        this.decryptPassword = password;
        this.setDecryptPasswordRequired(false);
        this.firePropertyChange("decryptPassword", oldValue, this.decryptPassword);
    }

    public void setDecryptPasswordToNull(String password) {
        String oldValue = this.decryptPassword;
        this.decryptPassword = password;
        this.firePropertyChange("decryptPassword", oldValue, this.decryptPassword);
    }

    public void setDecryptPasswordByEncryption(String decryptedPassword) {
        String password = Utility.decrypt(Confirm.resources.getString("APP_FRAME_NAME"), decryptedPassword);
        this.setDecryptPassword(password);
    }

    public boolean isDecodeToSameFolder() {
        return this.decodeToSameFolder;
    }

    public void setDecodeToSameFolder(boolean decodeToSameFolder) {
        boolean oldValue = this.decodeToSameFolder;
        this.decodeToSameFolder = decodeToSameFolder;
        this.firePropertyChange("decodeToSameFolder", oldValue, this.decodeToSameFolder);
    }

    public String getDecodeFolderPath() {
        return this.decodeFolderPath;
    }

    public void setDecodeFolderPath(String decodeFolderPath) {
        String oldValue = this.decodeFolderPath;
        this.decodeFolderPath = decodeFolderPath;
        this.firePropertyChange("decodeFolderPath", oldValue, this.decodeFolderPath);
    }

    public int getRunMode() {
        return this.runMode;
    }

    public void setRunMode(int runMode) {
        this.runMode = runMode;
    }

    public String getEncryptPasswordFileName() {
        return this.encryptPasswordFileName;
    }

    public String getDecryptPasswordFileName() {
        return this.decryptPasswordFileName;
    }

    public void setDecryptPasswordFileName(String passwordFileName) {
        String oldValue = this.decryptPasswordFileName;
        this.decryptPasswordFileName = passwordFileName;
        this.setDecryptPasswardRequired(this.decryptPasswordFileName != null);
        this.firePropertyChange("decryptPasswordFileName", oldValue, this.decryptPasswordFileName);
    }

    public void setEncryptPasswordFileName(String passwordFileName) {
        String oldValue = this.encryptPasswordFileName;
        this.encryptPasswordFileName = passwordFileName;
        this.setEncryptPasswardRequired(this.encryptPasswordFileName != null);
        this.firePropertyChange("encryptPasswordFileName", oldValue, this.encryptPasswordFileName);
    }

    public int getDeleteMode() {
        return this.deleteMode;
    }

    public void setDeleteMode(int deleteMode) {
        int oldValue = this.deleteMode;
        this.deleteMode = deleteMode;
        this.firePropertyChange("deleteMode", oldValue, this.deleteMode);
    }

    public int getRandomWriteCount() {
        return this.randomWriteCount;
    }

    public void setRandomWriteCount(int randomWriteCount) {
        int oldValue = this.randomWriteCount;
        this.randomWriteCount = randomWriteCount;
        this.firePropertyChange("randomWriteCount", oldValue, this.randomWriteCount);
    }

    public int getZeroWriteCount() {
        return this.zeroWriteCount;
    }

    public void setZeroWriteCount(int zeroWriteCount) {
        int oldValue = this.zeroWriteCount;
        this.zeroWriteCount = zeroWriteCount;
        this.firePropertyChange("zeroWriteCount", oldValue, this.zeroWriteCount);
    }

    public boolean isCui() {
        return this.cui;
    }

    public boolean isFileBrakeOption() {
        return this.fileBrakeOption;
    }

    public void setFileBrakeOption(boolean fileBrakeOption) {
        boolean oldValue = this.fileBrakeOption;
        this.fileBrakeOption = fileBrakeOption;
        this.firePropertyChange("fileBrakeOption", oldValue, this.fileBrakeOption);
    }

    public int getMaxMistake() {
        return this.maxMistake;
    }

    public void setMaxMistake(int maxMistake) {
        int oldValue = this.maxMistake;
        this.maxMistake = maxMistake;
        this.firePropertyChange("maxMistake", oldValue, this.maxMistake);
    }

    private boolean validateOptions(String[] args) {
        ArrayList<String> optionArgs = new ArrayList<String>();
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.startsWith("--") || s.startsWith("-")) {
                optionArgs.add(s);
            }
            ++n2;
        }
        boolean valid = true;
        for (String s : optionArgs) {
            String arg;
            if (!valid) break;
            if (s.startsWith("--")) {
                arg = s.substring(2);
                valid = this.isValidOption(arg);
                continue;
            }
            arg = s.substring(1);
            int i = 0;
            while (i < arg.length()) {
                valid = this.isValidOption(arg.charAt(i), i == 0);
                ++i;
            }
        }
        return valid;
    }

    private boolean isValidOption(String arg) {
        boolean valid = false;
        CommandOption[] commandOptionArray = this.commandOptions;
        int n = this.commandOptions.length;
        int n2 = 0;
        while (n2 < n) {
            CommandOption opt = commandOptionArray[n2];
            if (arg.equals(opt.getName())) {
                valid = true;
                break;
            }
            ++n2;
        }
        return valid;
    }

    private boolean isValidOption(char arg, boolean top) {
        boolean valid = false;
        CommandOption[] commandOptionArray = this.commandOptions;
        int n = this.commandOptions.length;
        int n2 = 0;
        while (n2 < n) {
            CommandOption opt = commandOptionArray[n2];
            if (top) {
                if (arg == opt.getShortName().charValue()) {
                    valid = true;
                    break;
                }
            } else if (arg == opt.getShortName().charValue() && !opt.getExpectsArgument()) {
                valid = true;
                break;
            }
            ++n2;
        }
        return valid;
    }

    public boolean isNotMulipleStarts() {
        return this.notMulipleStarts;
    }

    public void setNotMulipleStarts(boolean notMulipleStarts) {
        boolean oldValue = this.notMulipleStarts;
        this.notMulipleStarts = notMulipleStarts;
        this.firePropertyChange("notMulipleStarts", oldValue, this.notMulipleStarts);
    }

    public boolean isEncryptPasswordRequired() {
        if (this.usePasswordFile && this.encryptPasswordFileName != null && this.encryptPasswordFileName.length() > 0) {
            return false;
        }
        if (this.memoryEncryptPassword && this.encryptPassword != null && this.encryptPassword.length() > 0) {
            return false;
        }
        return this.encryptPasswordRequired;
    }

    public void setEncryptPasswordRequired(boolean encryptPasswordRequired) {
        boolean oldValue = this.encryptPasswordRequired;
        this.encryptPasswordRequired = encryptPasswordRequired;
        this.firePropertyChange("encryptPasswordRequired", oldValue, this.encryptPasswordRequired);
    }

    public boolean isDecryptPasswordRequired() {
        if (this.usePasswordFile && this.decryptPasswordFileName != null && this.decryptPasswordFileName.length() > 0) {
            return false;
        }
        if (this.memoryDecryptPassword && this.decryptPassword != null && this.decryptPassword.length() > 0) {
            return false;
        }
        return this.decryptPasswordRequired;
    }

    public void setDecryptPasswordRequired(boolean decryptPasswordRequired) {
        boolean oldValue = this.decryptPasswordRequired;
        this.decryptPasswordRequired = decryptPasswordRequired;
        this.firePropertyChange("decryptPasswordRequired", oldValue, this.decryptPasswordRequired);
    }

    public void setIncludeHidden(boolean includeHidden) {
        boolean oldValue = this.includeHidden;
        this.includeHidden = includeHidden;
        this.firePropertyChange("includeHidden", oldValue, this.includeHidden);
    }

    public boolean isQuitAfterEncrypt() {
        return this.quitAfterEncrypt;
    }

    public void setQuitAfterEncrypt(boolean quitAfterEncrypt) {
        boolean oldValue = this.quitAfterEncrypt;
        this.quitAfterEncrypt = quitAfterEncrypt;
        this.firePropertyChange("quitAfterEncrypt", oldValue, this.quitAfterEncrypt);
    }

    public boolean isAlwaysOnTop() {
        return this.alwaysOnTop;
    }

    public void setAlwaysOnTop(boolean alwaysOnTop) {
        boolean oldValue = this.alwaysOnTop;
        this.alwaysOnTop = alwaysOnTop;
        this.firePropertyChange("alwaysOnTop", oldValue, this.alwaysOnTop);
    }

    public boolean isOpenDirectoryAfterDecrypt() {
        return this.openDirectoryAfterDecrypt;
    }

    public void setOpenDirectoryAfterDecrypt(boolean openDirectoryAfterDecrypt) {
        boolean oldValue = this.openDirectoryAfterDecrypt;
        this.openDirectoryAfterDecrypt = openDirectoryAfterDecrypt;
        this.firePropertyChange("openDirectoryAfterDecrypt", oldValue, this.openDirectoryAfterDecrypt);
    }

    public boolean isAskEncryptOrDecrypt() {
        return this.askEncryptOrDecrypt;
    }

    public void setAskEncryptOrDecrypt(boolean askEncryptOrDecrypt) {
        boolean oldValue = askEncryptOrDecrypt;
        this.askEncryptOrDecrypt = askEncryptOrDecrypt;
        this.firePropertyChange("askEncryptOrDecrypt", oldValue, this.askEncryptOrDecrypt);
    }

    public boolean isMemoryEncryptPassword() {
        return this.memoryEncryptPassword;
    }

    public void setMemoryEncryptPassword(boolean memoryEncryptPassword) {
        boolean oldValue = this.memoryEncryptPassword;
        this.memoryEncryptPassword = memoryEncryptPassword;
        this.firePropertyChange("memoryEncryptPassword", oldValue, this.memoryEncryptPassword);
    }

    public boolean isMemoryDecryptPassword() {
        return this.memoryDecryptPassword;
    }

    public void setMemoryDecryptPassword(boolean memoryDecryptPassword) {
        boolean oldValue = this.memoryDecryptPassword;
        this.memoryDecryptPassword = memoryDecryptPassword;
        this.firePropertyChange("memoryDecryptPassword", oldValue, this.memoryDecryptPassword);
    }

    public boolean isEncryptWithoutConfirmation() {
        return this.encryptWithoutConfirmation;
    }

    public void setEncryptWithoutConfirmation(boolean encryptWithoutConfirmation) {
        boolean oldValue = this.encryptWithoutConfirmation;
        this.encryptWithoutConfirmation = encryptWithoutConfirmation;
        this.firePropertyChange("encryptWithoutConfirmation", oldValue, this.encryptWithoutConfirmation);
        this.setEncryptPasswordRequired(this.encryptPassword != null);
        this.setDecryptPasswardRequired(this.decryptPassword != null);
    }

    public boolean isShowPassword() {
        return this.showPassword;
    }

    public void setShowPassword(boolean showPassword) {
        boolean oldValue = this.showPassword;
        this.showPassword = showPassword;
        this.firePropertyChange("showPassword", oldValue, this.showPassword);
    }

    public boolean isEncodeToSameFolder() {
        return this.encodeToSameFolder;
    }

    public void setEncodeToSameFolder(boolean encodeToSameFolder) {
        boolean oldValue = this.encodeToSameFolder;
        this.encodeToSameFolder = encodeToSameFolder;
        this.firePropertyChange("encodeToSameFolder", oldValue, this.encodeToSameFolder);
    }

    public String getEncodeFolderPath() {
        return this.encodeFolderPath;
    }

    public void setEncodeFolderPath(String encodeFolderPath) {
        String oldValue = this.encodeFolderPath;
        this.encodeFolderPath = encodeFolderPath;
        this.firePropertyChange("encodeFolderPath", oldValue, this.encodeFolderPath);
    }

    public boolean isNotMakeParentFolder() {
        return this.notMakeParentFolder;
    }

    public void setNotMakeParentFolder(boolean notMakeParentFolder) {
        boolean oldValue = this.notMakeParentFolder;
        this.notMakeParentFolder = notMakeParentFolder;
        this.firePropertyChange("notMakeParentFolder", oldValue, this.notMakeParentFolder);
    }

    public boolean isUsePasswordFile() {
        return this.usePasswordFile;
    }

    public void setUsePasswordFile(boolean usePasswordFile) {
        boolean oldValue = this.usePasswordFile;
        this.usePasswordFile = usePasswordFile;
        this.firePropertyChange("usePasswordFile", oldValue, this.usePasswordFile);
    }

    public Options clone() throws CloneNotSupportedException {
        return (Options)super.clone();
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public boolean isAddFileName() {
        return this.addFileName;
    }

    public void setAddFileName(boolean addFileName) {
        this.addFileName = addFileName;
    }

    private String getIniFileDefault() {
        StringBuilder name = new StringBuilder(Utility.includeTrailingPathDelimiter(System.getProperty("user.dir")));
        name.append("attachecase.ini");
        return name.toString();
    }

    private String getIniFileNameFromResource() {
        File dir = null;
        URL url = Options.class.getResource("Options.class");
        String protocol = url.getProtocol();
        if (protocol.equals("jar")) {
            Pattern p = Pattern.compile("(file:/.*)!/");
            Matcher m = p.matcher(url.toString());
            if (!m.find()) {
                return this.getIniFileDefault();
            }
            File jarFile = null;
            try {
                jarFile = new File(new URI(m.group(1)));
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                return this.getIniFileDefault();
            }
            dir = jarFile.getParentFile();
        } else if (protocol.equals("file")) {
            File classFile = null;
            try {
                classFile = new File(new URI(url.toString()));
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                return this.getIniFileDefault();
            }
            Package pack = Options.class.getPackage();
            if (pack == null) {
                dir = classFile.getParentFile();
            } else {
                String packName = pack.getName();
                String[] dirs = packName.split("\\.");
                dir = classFile.getParentFile();
                int i = 0;
                while (i < dirs.length) {
                    dir = dir.getParentFile();
                    ++i;
                }
            }
        } else {
            return this.getIniFileDefault();
        }
        File iniFile = new File(dir, "attachecase.ini");
        return iniFile.getAbsolutePath();
    }

    private String getIniFileName() {
        if (Utility.isMac()) {
            return MAC_INI_FILE_PATH;
        }
        String fileName = null;
        String cp = System.getProperty("java.class.path");
        int pos = cp.indexOf(58);
        if (pos >= 0 && pos != 1) {
            cp = cp.substring(pos + 1);
        }
        if (cp.endsWith("attachecase.jar")) {
            String dirPath = cp.substring(0, cp.lastIndexOf(File.separator) + 1);
            fileName = String.valueOf(dirPath) + "attachecase.ini";
        } else {
            fileName = this.getIniFileNameFromResource();
        }
        return fileName;
    }

    public void loadFromFile() {
        Wini ini = null;
        File f = new File(this.getIniFileName());
        if (!f.exists()) {
            return;
        }
        try {
            try {
                ini = new Wini(f);
                BeanInfo beanInfo = Introspector.getBeanInfo(Options.class);
                PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
                String[][] stringArray = PROPERTIES;
                int n = PROPERTIES.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] properties = stringArray[n2];
                    String sectionName = properties[0];
                    int i = 1;
                    while (i < properties.length) {
                        String value = ini.get((Object)sectionName, (Object)properties[i]);
                        if (value != null) {
                            Method method;
                            PropertyDescriptor pd;
                            String propertyName = properties[i];
                            if (this.isEncryptProperty(propertyName)) {
                                propertyName = String.valueOf(propertyName) + "ByEncryption";
                            }
                            if ((pd = Options.findPropertyDescriptor(propertyDescriptors, propertyName)) != null && (method = pd.getWriteMethod()) != null) {
                                if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
                                    method.invoke((Object)this, new Boolean(value));
                                } else {
                                    try {
                                        method.invoke((Object)this, new Integer(value));
                                    }
                                    catch (NumberFormatException e) {
                                        method.invoke((Object)this, value);
                                    }
                                }
                            }
                        }
                        ++i;
                    }
                    ++n2;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ini = null;
            }
            catch (IllegalAccessException illegalAccessException) {
                ini = null;
            }
            catch (InvocationTargetException invocationTargetException) {
                ini = null;
            }
            catch (IntrospectionException introspectionException) {
                ini = null;
            }
            catch (IOException iOException) {
                ini = null;
            }
        }
        finally {
            ini = null;
        }
    }

    public void saveToFile() {
        Wini ini = null;
        try {
            try {
                File file = new File(this.getIniFileName());
                if (!file.exists()) {
                    file.createNewFile();
                }
                ini = new Wini(file);
                BeanInfo beanInfo = Introspector.getBeanInfo(Options.class);
                PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
                String[][] stringArray = PROPERTIES;
                int n = PROPERTIES.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] properties = stringArray[n2];
                    String sectionName = properties[0];
                    int i = 1;
                    while (i < properties.length) {
                        Method method;
                        PropertyDescriptor pd;
                        String propertyName = properties[i];
                        if (this.isEncryptProperty(propertyName)) {
                            propertyName = String.valueOf(propertyName) + "ByEncryption";
                        }
                        if ((pd = Options.findPropertyDescriptor(propertyDescriptors, propertyName)) != null && (method = pd.getReadMethod()) != null) {
                            ini.put(sectionName, properties[i], method.invoke((Object)this, null));
                        }
                        ++i;
                    }
                    ++n2;
                }
                ini.store();
            }
            catch (IntrospectionException introspectionException) {
                ini = null;
            }
            catch (IOException iOException) {
                ini = null;
            }
            catch (InvocationTargetException invocationTargetException) {
                ini = null;
            }
            catch (IllegalAccessException illegalAccessException) {
                ini = null;
            }
            catch (Exception exception) {
                ini = null;
            }
        }
        finally {
            ini = null;
        }
    }

    private static PropertyDescriptor findPropertyDescriptor(PropertyDescriptor[] descriptors, String propertyName) {
        PropertyDescriptor[] propertyDescriptorArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor pd = propertyDescriptorArray[n2];
            if (pd.getName().equals(propertyName)) {
                return pd;
            }
            ++n2;
        }
        return null;
    }

    public boolean isUsePasswordOption() {
        return this.usePasswordOption;
    }

    public void setUsePasswordOption(boolean usePasswordOption) {
        this.usePasswordOption = usePasswordOption;
    }

    boolean isEncryptProperty(String propertyName) {
        String[] stringArray = ENCRYPT_PROPERTIES;
        int n = ENCRYPT_PROPERTIES.length;
        int n2 = 0;
        while (n2 < n) {
            String property = stringArray[n2];
            if (property.equals(propertyName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isUseVersion2() {
        return this.useVersion2;
    }

    public void setUseVersion2(boolean useVersion2) {
        this.useVersion2 = useVersion2;
    }
}

