/*
 * Decompiled with CFR 0.152.
 */
package org.hibara.attachecase;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.hibara.attachecase.Confirm;
import org.hibara.attachecase.utility.Utility;

public class DialogConfirm
implements Confirm {
    private JFrame parent = null;

    public DialogConfirm() {
        this(null);
    }

    public DialogConfirm(JFrame parent) {
        this.parent = parent;
    }

    public JFrame getParent() {
        return this.parent;
    }

    public void setParent(JFrame parent) {
        this.parent = parent;
    }

    @Override
    public int confirmYesNo(String s, boolean bundle) {
        if (bundle) {
            s = resources.getString(s).trim();
        }
        s = this.removeNewLineOfEnd(s);
        int result = JOptionPane.showConfirmDialog(this.parent, s, resources.getString("YES_NO_SELECT_DIALOG"), 0, 3, new ImageIcon(this.getClass().getResource("/icon_help.png")));
        switch (result) {
            case -1: 
            case 1: {
                result = -1;
                break;
            }
            case 0: {
                result = 1;
            }
        }
        return result;
    }

    @Override
    public int confirmYesNoAll(String s, boolean bundle) {
        if (bundle) {
            s = resources.getString(s).trim();
        }
        s = this.removeNewLineOfEnd(s);
        Object[] options = new String[]{resources.getString("SELECT_OPTION_ALL"), resources.getString("SELECT_OPTION_YES"), resources.getString("SELECT_OPTION_NO")};
        int result = JOptionPane.showOptionDialog(this.parent, s, resources.getString("YES_NO_ALL_SELECT_DIALOG"), 1, 3, new ImageIcon(this.getClass().getResource("/icon_help.png")), options, resources.getString("SELECT_OPTION_ALL"));
        switch (result) {
            case 0: {
                result = 2;
                break;
            }
            case 1: {
                result = 1;
                break;
            }
            default: {
                result = -1;
            }
        }
        return result;
    }

    @Override
    public int confirmYesNoCancel(String s, boolean bundle) {
        if (bundle) {
            s = resources.getString(s).trim();
        }
        s = this.removeNewLineOfEnd(s);
        int result = JOptionPane.showConfirmDialog(this.parent, s, resources.getString("YES_NO_SELECT_DIALOG"), 1, 3, new ImageIcon(this.getClass().getResource("/icon_help.png")));
        switch (result) {
            case -1: 
            case 1: {
                result = -1;
                break;
            }
            case 0: {
                result = 1;
                break;
            }
            default: {
                result = -2;
            }
        }
        return result;
    }

    @Override
    public int confirmYesNoAllCancel(String s, boolean bundle) {
        if (bundle) {
            s = resources.getString(s).trim();
        }
        s = this.removeNewLineOfEnd(s);
        Object[] options = new String[]{resources.getString("SELECT_OPTION_ALL"), resources.getString("SELECT_OPTION_YES"), resources.getString("SELECT_OPTION_NO"), resources.getString("SELECT_OPTION_CANCEL")};
        int result = JOptionPane.showOptionDialog(this.parent, s, resources.getString("YES_NO_ALL_SELECT_DIALOG"), 1, 3, new ImageIcon(this.getClass().getResource("/icon_help.png")), options, resources.getString("SELECT_OPTION_ALL"));
        switch (result) {
            case 0: {
                result = 2;
                break;
            }
            case 1: {
                result = 1;
                break;
            }
            case -1: 
            case 2: {
                result = -1;
                break;
            }
            default: {
                result = -2;
            }
        }
        return result;
    }

    @Override
    public String inputPassword(int loop) {
        return this.inputPassword(null, loop);
    }

    @Override
    public String inputPassword(String fileName, int loop) {
        return this.inputPassword(fileName, loop, false);
    }

    @Override
    public String inputPassword(String fileName, int loop, boolean showPassword) {
        if (loop < 0) {
            loop = 1;
        }
        if (loop > 2) {
            loop = 2;
        }
        String[] inputPasswords = new String[2];
        int count = 0;
        while (count < loop) {
            StringBuilder sb = new StringBuilder();
            if (fileName != null) {
                sb.append('[').append(fileName).append("] ");
            }
            sb.append(resources.getString(count == 0 ? "MSG_INPUT_PASSWORD" : "MSG_INPUT_PASSWORD_AGAIN"));
            if (sb.indexOf(":") != -1) {
                sb.delete(sb.indexOf(":"), sb.length());
            }
            String result = null;
            JPanel panel = new JPanel();
            BoxLayout layout = new BoxLayout(panel, 1);
            panel.setLayout(layout);
            JTextField pass = null;
            pass = !showPassword ? new JPasswordField(20) : new JTextField(20);
            pass.setEditable(true);
            pass.setEnabled(true);
            panel.add(new JLabel(sb.toString()));
            panel.add(pass);
            JOptionPane optionPane = new JOptionPane(panel, 1, 2, new ImageIcon(this.getClass().getResource("/user_secured.png"))){
                private static final long serialVersionUID = 1L;

                @Override
                public void selectInitialValue() {
                }
            };
            JDialog dlg = optionPane.createDialog(this.parent, sb.toString());
            dlg.setDefaultCloseOperation(2);
            dlg.setVisible(true);
            Integer select = (Integer)optionPane.getValue();
            if (select == null || select != 0) {
                return null;
            }
            String string = result = !showPassword ? new String(((JPasswordField)pass).getPassword()) : pass.getText();
            if (count == 1 && !inputPasswords[0].equals(result)) {
                this.showErrorMessageByBundle("MSG_ERROR_PASSWORD_DIFFERENCE");
                continue;
            }
            inputPasswords[count++] = result;
        }
        return new String(inputPasswords[0]);
    }

    @Override
    public String inputDirName(File f) {
        String path = this.getFileName(f, this.removeNewLineOfEnd(resources.getString("MSG_INPUT_NEW_DIR")), 1, null);
        return Utility.rejectPathTraversal(path);
    }

    @Override
    public String inputFileName(File f) {
        String path = this.getFileName(f, this.removeNewLineOfEnd(resources.getString("MSG_INPUT_NEW_FILE")), 2, null);
        if (path == null) {
            return null;
        }
        return Utility.rejectPathTraversal(path);
    }

    @Override
    public void showMessageByBundle(String bundle) {
        this.showErrorMessage(resources.getString(bundle));
    }

    @Override
    public void showErrorMessageByBundle(String bundle) {
        this.showErrorMessage(resources.getString(bundle));
    }

    @Override
    public void showMessage(String str) {
        str = this.removeNewLineOfEnd(str);
        JOptionPane.showMessageDialog(this.parent, str, resources.getString("MESSAGE_DIALOG"), 1, new ImageIcon(this.getClass().getResource("/icon_info.png")));
    }

    @Override
    public void showErrorMessage(String str) {
        str = this.removeNewLineOfEnd(str);
        JOptionPane.showMessageDialog(this.parent, str, resources.getString("MESSAGE_DIALOG"), 0, new ImageIcon(this.getClass().getResource("/icon_warning.png")));
    }

    public String getFileName(File f, String title, int mode, FileFilter filter) {
        JFileChooser chooser = new JFileChooser();
        if (f != null) {
            chooser.setCurrentDirectory(f);
        }
        if (filter != null) {
            chooser.addChoosableFileFilter(filter);
        }
        chooser.setFileSelectionMode(mode);
        chooser.setDialogTitle(title);
        int result = chooser.showSaveDialog(this.parent);
        if (result == 1) {
            return null;
        }
        return chooser.getSelectedFile().getAbsolutePath();
    }

    public List<File> getFiles(File f, String title, int mode, FileFilter filter) {
        JFileChooser chooser = new JFileChooser();
        ArrayList<File> files = new ArrayList<File>();
        if (f != null) {
            chooser.setCurrentDirectory(f);
        }
        if (filter != null) {
            chooser.addChoosableFileFilter(filter);
        }
        chooser.setFileSelectionMode(mode);
        chooser.setDialogTitle(title);
        chooser.setMultiSelectionEnabled(true);
        int result = chooser.showOpenDialog(this.parent);
        if (result == 1) {
            return files;
        }
        File[] fileArray = chooser.getSelectedFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            files.add(file);
            ++n2;
        }
        return files;
    }

    private String removeNewLineOfEnd(String s) {
        StringBuilder sb = new StringBuilder(s);
        char ch = sb.charAt(sb.length() - 1);
        while (ch == '\n' || ch == '\r') {
            sb.deleteCharAt(sb.length() - 1);
            ch = sb.charAt(sb.length() - 1);
        }
        return sb.toString();
    }
}

