/*
 * Decompiled with CFR 0.152.
 */
package org.hibara.attachecase;

import java.io.Console;
import java.io.File;
import org.hibara.attachecase.AttacheCaseConstant;
import org.hibara.attachecase.Confirm;
import org.hibara.attachecase.utility.Utility;

public class ConsoleConfirm
implements Confirm,
AttacheCaseConstant {
    private static Console console = System.console();
    private static final String YES_NO = "Yes/No";
    private static final String YES_NO_CANCEL = "Yes/No/Cancel";
    private static final String YES_NO_ALL = "Yes/No/All";
    private static final String YES_NO_ALL_CANCEL = "Yes/No/All/Cancel";

    @Override
    public int confirmYesNo(String s, boolean bundle) {
        String str = this.inputFromConsole(s, bundle, YES_NO, 10);
        if (str.toUpperCase().startsWith("Y") || str.toUpperCase().equals("YES")) {
            return 1;
        }
        return -1;
    }

    @Override
    public int confirmYesNoCancel(String s, boolean bundle) {
        String str = this.inputFromConsole(s, bundle, YES_NO_CANCEL, 10);
        if (str.toUpperCase().startsWith("Y") || str.toUpperCase().equals("YES")) {
            return 1;
        }
        if (str.toUpperCase().startsWith("C") || str.toUpperCase().equals("CANCEL")) {
            return -2;
        }
        return -1;
    }

    @Override
    public int confirmYesNoAll(String s, boolean bundle) {
        String str = this.inputFromConsole(s, bundle, YES_NO_ALL, 10);
        if (str.toUpperCase().startsWith("Y") || str.toUpperCase().equals("YES")) {
            return 1;
        }
        if (str.toUpperCase().startsWith("A") || str.toUpperCase().equals("ALL")) {
            return 2;
        }
        return -1;
    }

    @Override
    public int confirmYesNoAllCancel(String s, boolean bundle) {
        String str = this.inputFromConsole(s, bundle, YES_NO_ALL_CANCEL, 10);
        if (str.toUpperCase().startsWith("Y") || str.toUpperCase().equals("YES")) {
            return 1;
        }
        if (str.toUpperCase().startsWith("A") || str.toUpperCase().equals("ALL")) {
            return 2;
        }
        if (str.toUpperCase().startsWith("C") || str.toUpperCase().equals("CANCEL")) {
            return -2;
        }
        return -1;
    }

    @Override
    public String inputPassword(int loop) {
        return this.inputPassword(null, loop);
    }

    @Override
    public String inputPassword(String fileName, int loop) {
        if (loop < 0) {
            loop = 1;
        }
        if (loop > 2) {
            loop = 2;
        }
        String[] inputPasswords = new String[2];
        int count = 0;
        while (count < loop) {
            StringBuilder sb = new StringBuilder();
            if (fileName != null) {
                sb.append('[').append(fileName).append("] ");
            }
            sb.append(resources.getString(count == 0 ? "MSG_INPUT_PASSWORD" : "MSG_INPUT_PASSWORD_AGAIN"));
            char[] passwordChars = console.readPassword("%s", sb.toString());
            if (passwordChars == null || passwordChars.length == 0) continue;
            String password = new String(passwordChars);
            if (count == 1 && !inputPasswords[0].equals(password)) {
                this.showErrorMessageByBundle("MSG_ERROR_PASSWORD_DIFFERENCE");
                continue;
            }
            inputPasswords[count++] = password;
        }
        return new String(inputPasswords[0]);
    }

    @Override
    public String inputPassword(String fileName, int loop, boolean showPassword) {
        return this.inputPassword(fileName, loop);
    }

    @Override
    public void showMessageByBundle(String bundle) {
        if (bundle != null) {
            this.showMessage(resources.getString(bundle));
        }
    }

    @Override
    public void showMessage(String str) {
        console.printf("%s", str);
    }

    @Override
    public void showErrorMessageByBundle(String bundle) {
        if (bundle != null) {
            this.showErrorMessage(resources.getString(bundle));
        }
    }

    @Override
    public void showErrorMessage(String str) {
        System.err.printf("%s", str);
    }

    private String inputFromConsole(String s, boolean bundle, String allowStr, int loop) {
        if (loop < 0) {
            loop = Integer.MAX_VALUE;
        }
        String msg = String.valueOf(allowStr) + " : ";
        if (bundle && s != null) {
            s = resources.getString(s);
        }
        if (s != null) {
            msg = String.valueOf(s) + msg;
        }
        String[] allow = allowStr.split("/");
        if (loop < 0) {
            loop = Integer.MAX_VALUE;
        }
        String inputStr = "";
        int i = 0;
        while (i < loop) {
            inputStr = console.readLine("%s", msg);
            if (this.isContained(allow, inputStr)) break;
            ++i;
        }
        return inputStr;
    }

    private boolean isContained(String[] array, String s) {
        boolean contained = false;
        if (s.length() == 0) {
            return contained;
        }
        int i = 0;
        while (i < array.length) {
            String upper = array[i].toUpperCase();
            if (upper.equals(s.toUpperCase()) || upper.startsWith(s.toUpperCase())) {
                contained = true;
                break;
            }
            ++i;
        }
        return contained;
    }

    @Override
    public String inputDirName(File f) {
        String path = null;
        while (path == null) {
            path = console.readLine("%s", resources.getString("MSG_INPUT_NEW_DIR"));
            if (path.length() == 0 || path.equals("\n")) {
                path = null;
                continue;
            }
            File file = new File(path = Utility.includeTrailingPathDelimiter(path));
            if (file.exists() || file.isFile()) {
                String msg = resources.getString(file.isFile() ? "MSG_ERROR_NO_DIR_NAME" : "MSG_ERROR_DIR_EXIST");
                if (msg.endsWith("\n")) {
                    msg = String.valueOf(msg.substring(0, msg.indexOf(10) - 1)) + resources.getString("MSG_INPUT_NEW_DIR");
                }
                console.printf("%s", msg);
                path = null;
                continue;
            }
            path = file.getAbsolutePath();
        }
        return path;
    }

    @Override
    public String inputFileName(File f) {
        String path = null;
        while (path == null) {
            path = console.readLine("%s", resources.getString("MSG_INPUT_NEW_FILE"));
            if ((path = Utility.rejectPathTraversal(path)).length() == 0 || path.equals("\n")) {
                path = null;
                continue;
            }
            File file = new File(path);
            if (file.exists() || file.isDirectory()) {
                String msg = resources.getString(file.isDirectory() ? "MSG_ERROR_NO_FILE_NAME" : "MSG_ERROR_FILE_EXIST");
                if (msg.endsWith("\n")) {
                    msg = String.valueOf(msg.substring(0, msg.indexOf(10) - 1)) + resources.getString("MSG_INPUT_NEW_FILE");
                }
                console.printf("%s", msg);
                path = null;
                continue;
            }
            path = file.getAbsolutePath();
        }
        return path;
    }
}

