/*
 * Decompiled with CFR 0.152.
 */
package org.hibara.attachecase;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.hibara.attachecase.AttacheCaseConstant;
import org.hibara.attachecase.Confirm;
import org.hibara.attachecase.DialogConfirm;
import org.hibara.attachecase.Options;
import org.hibara.attachecase.encrypt.Encrypt;
import org.hibara.attachecase.encrypt.FileDecrypt2;
import org.hibara.attachecase.encrypt.FileDecrypt3;
import org.hibara.attachecase.encrypt.FileEncrypt;
import org.hibara.attachecase.encrypt.FileEncrypt3;
import org.hibara.attachecase.entity.ShaEntity;
import org.hibara.attachecase.exception.PasswordException;
import org.hibara.attachecase.gui.ButtonPanel;
import org.hibara.attachecase.gui.IconButton;
import org.hibara.attachecase.gui.OptionDialog;
import org.hibara.attachecase.io.AtcFileFilter;
import org.hibara.attachecase.utility.AbstractProgressListener;
import org.hibara.attachecase.utility.Digest;
import org.hibara.attachecase.utility.Utility;

public class AttacheCase4GUI
extends JFrame
implements AttacheCaseConstant {
    private static final long serialVersionUID = 2612224766701174329L;
    private static AttacheCase4GUI frame = null;
    private ResourceBundle bandle = Confirm.resources;
    private final Action encryptAction = new EncryptAction();
    private final Action decryptAction = new DecryptAction();
    private final Action settingAction = new SettingAction();
    private final Action quitAction = new QuitAction();
    private Button cancelButton;
    private JProgressBar progressBar = null;
    private JLabel statusText = null;
    private List<File> fileList = null;
    private SwingWorker<Void, Integer> encryptWorker = null;
    private Options options = null;
    private DialogConfirm confirm = null;
    private int version = -1;

    public AttacheCase4GUI() {
        this(new Options());
    }

    public AttacheCase4GUI(Options opt) {
        if (opt == null) {
            opt = new Options();
        }
        this.options = opt;
        this.setPreferredSize(new Dimension(440, 320));
        this.setMinimumSize(new Dimension(440, 320));
        this.setMaximumSize(new Dimension(440, 320));
        this.setResizable(false);
        this.setAlwaysOnTop(this.options.isAlwaysOnTop());
        frame = this;
        this.confirm = new DialogConfirm(this);
        this.setTitle(this.bandle.getString("APP_FRAME_NAME"));
        JMenuBar menuBar = new JMenuBar();
        menuBar.setBounds(0, 0, 132, 22);
        this.setJMenuBar(menuBar);
        JMenu menu = new JMenu(this.bandle.getString("MENU_FILE"));
        if (!Utility.isMac()) {
            menu.setText(String.valueOf(menu.getText()) + "(F)");
            menu.setMnemonic(70);
        }
        menuBar.add(menu);
        JMenuItem encryptMenuItem = new JMenuItem(this.bandle.getString("MENU_ENCRYPT_FILE"));
        encryptMenuItem.setAction(this.encryptAction);
        if (!Utility.isMac()) {
            encryptMenuItem.setText(String.valueOf(encryptMenuItem.getText()) + "(O)");
            encryptMenuItem.setMnemonic(79);
        }
        encryptMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, AttacheCaseConstant.SHORT_CUT_KEY));
        menu.add(encryptMenuItem);
        JMenuItem decryptMenuItem = new JMenuItem(this.bandle.getString("MENU_DECRYPT_FILE"));
        decryptMenuItem.setAction(this.decryptAction);
        if (!Utility.isMac()) {
            decryptMenuItem.setText(String.valueOf(menu.getText()) + "(D)");
            decryptMenuItem.setMnemonic(68);
        }
        decryptMenuItem.setAccelerator(KeyStroke.getKeyStroke(68, AttacheCaseConstant.SHORT_CUT_KEY));
        menu.add(decryptMenuItem);
        JMenuItem quitMenuItem = new JMenuItem(this.bandle.getString("MENU_QUIT"));
        if (!Utility.isMac()) {
            menu.addSeparator();
            quitMenuItem.setText(String.valueOf(menu.getText()) + "(C)");
            quitMenuItem.setMnemonic(67);
            menu.add(quitMenuItem);
        }
        JMenu optionMenu = new JMenu(this.bandle.getString("MENU_OPTION"));
        if (!Utility.isMac()) {
            optionMenu.setText(String.valueOf(optionMenu.getText()) + "(O)");
            optionMenu.setMnemonic(79);
        }
        menuBar.add(optionMenu);
        JMenuItem settingMenuItem = new JMenuItem(this.bandle.getString("MENU_SETTING"));
        if (!Utility.isMac()) {
            settingMenuItem.setText(String.valueOf(settingMenuItem.getText()) + "(T)...Ctrl+W");
            settingMenuItem.setMnemonic(87);
        } else {
            settingMenuItem.setText(String.valueOf(settingMenuItem.getText()) + "...\u2318+W");
        }
        settingMenuItem.setAction(this.settingAction);
        settingMenuItem.setAccelerator(KeyStroke.getKeyStroke(87, AttacheCaseConstant.SHORT_CUT_KEY));
        optionMenu.add(settingMenuItem);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AttacheCase4GUI.this.quit();
            }
        });
        this.setLocationRelativeTo(null);
        Panel panel = new Panel();
        panel.setPreferredSize(new Dimension(300, 120));
        panel.setMinimumSize(new Dimension(300, 120));
        this.getContentPane().add((Component)panel, "South");
        panel.setLayout(new GridLayout(3, 1));
        JPanel progressPanel = new JPanel();
        progressPanel.setBackground(Color.WHITE);
        progressPanel.setName("progressPanel");
        progressPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        panel.add(progressPanel);
        progressPanel.setLayout(new BorderLayout(0, 0));
        this.progressBar = new JProgressBar();
        this.progressBar.setVisible(false);
        this.progressBar.setStringPainted(true);
        progressPanel.add((Component)this.progressBar, "Center");
        Panel buttonPanel = new Panel();
        buttonPanel.setBackground(Color.WHITE);
        buttonPanel.setName("buttonPanel");
        panel.add(buttonPanel);
        this.cancelButton = new Button(this.bandle.getString("MENU_QUIT"));
        this.cancelButton.addActionListener(this.quitAction);
        if (!Utility.isMac()) {
            this.cancelButton.setLabel(String.valueOf(this.cancelButton.getLabel()) + "(C)");
            optionMenu.setMnemonic(67);
        }
        buttonPanel.add(this.cancelButton);
        Panel statusPanel = new Panel();
        statusPanel.setBackground(UIManager.getColor("Button.background"));
        panel.add(statusPanel);
        statusPanel.setLayout(new FlowLayout(0, 5, 10));
        this.statusText = new JLabel("");
        this.statusText.setPreferredSize(new Dimension(390, 20));
        this.statusText.setHorizontalAlignment(2);
        statusPanel.add(this.statusText);
        ButtonPanel iconButtonPanel = new ButtonPanel();
        iconButtonPanel.setDrop(new DropTargetAdapter(){

            @Override
            public void drop(DropTargetDropEvent dtde) {
                frame.toFront();
                dtde.acceptDrop(1);
                Transferable trans = dtde.getTransferable();
                try {
                    if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                        AttacheCase4GUI.this.fileList = (List)trans.getTransferData(DataFlavor.javaFileListFlavor);
                    } else if (dtde.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                        String fileNames = (String)trans.getTransferData(DataFlavor.stringFlavor);
                        StringTokenizer st = new StringTokenizer(fileNames, "\n");
                        AttacheCase4GUI.this.fileList = new ArrayList();
                        while (st.hasMoreTokens()) {
                            String fileScheme = st.nextToken();
                            AttacheCase4GUI.this.fileList.add(new File(fileScheme.substring("file://".length()).trim()));
                        }
                    }
                    dtde.dropComplete(AttacheCase4GUI.this.fileList.size() != 0);
                    AttacheCase4GUI.this.run();
                }
                catch (UnsupportedFlavorException e) {
                    AttacheCase4GUI.this.confirm.showErrorMessage(e.getMessage());
                }
                catch (IOException e) {
                    AttacheCase4GUI.this.confirm.showErrorMessage(e.getMessage());
                }
            }
        });
        iconButtonPanel.setBackground(Color.WHITE);
        this.getContentPane().add((Component)iconButtonPanel, "Center");
        iconButtonPanel.setLayout(new GridLayout(1, 3));
        EmptyBorder emptyBoarder = new EmptyBorder(40, 0, 0, 0);
        JPanel encryptPanel = new JPanel();
        encryptPanel.setBackground(Color.WHITE);
        encryptPanel.setBorder(emptyBoarder);
        iconButtonPanel.add(encryptPanel);
        encryptPanel.setLayout(new FlowLayout(1));
        JLabel encryptLabel = new JLabel(this.bandle.getString("LABEL_ENCRYPT"));
        encryptLabel.setPreferredSize(new Dimension(100, 20));
        encryptLabel.setHorizontalAlignment(0);
        encryptPanel.add(encryptLabel);
        IconButton encryptButton = new IconButton("/1b72.png", "/1a72.png"){
            private static final long serialVersionUID = 1L;

            @Override
            public void mouseClicked(MouseEvent arg0) {
                AttacheCase4GUI.this.encryptAction.actionPerformed(null);
            }
        };
        encryptButton.setBackground(Color.WHITE);
        encryptPanel.add(encryptButton);
        JPanel decryptPanel = new JPanel();
        decryptPanel.setBackground(Color.WHITE);
        decryptPanel.setBorder(emptyBoarder);
        iconButtonPanel.add(decryptPanel);
        decryptPanel.setLayout(new FlowLayout(1));
        JLabel decryptLabel = new JLabel(this.bandle.getString("LABEL_DECRYPT"));
        decryptLabel.setPreferredSize(new Dimension(130, 20));
        decryptLabel.setHorizontalAlignment(0);
        decryptPanel.add(decryptLabel);
        IconButton decryptButton = new IconButton("/2b72.png", "/2a72.png"){
            private static final long serialVersionUID = -5935519443745942443L;

            @Override
            public void mouseClicked(MouseEvent arg0) {
                AttacheCase4GUI.this.decryptAction.actionPerformed(null);
            }
        };
        decryptPanel.add(decryptButton);
        JPanel optionPanel = new JPanel();
        optionPanel.setBackground(Color.WHITE);
        optionPanel.setBorder(emptyBoarder);
        iconButtonPanel.add(optionPanel);
        optionPanel.setLayout(new FlowLayout(1));
        JLabel optionLabel = new JLabel(this.bandle.getString("LABEL_OPTION"));
        optionLabel.setPreferredSize(new Dimension(100, 20));
        optionLabel.setHorizontalAlignment(0);
        optionPanel.add(optionLabel);
        IconButton optionButton = new IconButton("/3b72.png", "/3a72.png"){
            private static final long serialVersionUID = -5935519443745942443L;

            @Override
            public void mouseClicked(MouseEvent arg0) {
                AttacheCase4GUI.this.settingAction.actionPerformed(null);
            }
        };
        optionPanel.add(optionButton);
    }

    protected void quit() {
        this.options.saveToFile();
        System.exit(0);
    }

    public void setPassword(Encrypt encrypt) throws IOException, PasswordException {
        if (this.options.isEncryptPasswordRequired()) {
            String password = this.confirm.inputPassword(null, 2, this.options.isShowPassword());
            if (password == null) {
                throw new PasswordException();
            }
            this.options.setEncryptPasswardRequired(false);
            encrypt.setPassword(password);
        } else if (this.options.isUsePasswordFile() && this.options.getEncryptPasswordFileName() != null && this.options.getEncryptPasswordFileName().length() > 0) {
            Digest digest = new Digest();
            ShaEntity sha = digest.getHash(this.options.getEncryptPasswordFileName());
            encrypt.setSha(sha);
        } else {
            encrypt.setPassword(this.options.getEncryptPassword());
        }
    }

    public static AttacheCase4GUI getFrame() {
        return frame;
    }

    public void setFileList(List<File> fileList) {
        this.fileList = fileList;
    }

    public Action getDecryptAction() {
        return this.decryptAction;
    }

    public Options getOptions() {
        try {
            return this.options.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    public void run() {
        if (this.fileList != null && this.fileList.size() != 0) {
            this.version = Utility.getAtcVersion(this.fileList.get(0));
            if (this.options.isAskEncryptOrDecrypt()) {
                Object[] objectArray;
                if (Utility.isMac()) {
                    Object[] objectArray2 = new String[3];
                    objectArray2[0] = this.bandle.getString("LABEL_DECRYPT_SHORT");
                    objectArray2[1] = this.bandle.getString("LABEL_ENCRYPT");
                    objectArray = objectArray2;
                    objectArray2[2] = this.bandle.getString("LABEL_CANCEL");
                } else {
                    String[] stringArray = new String[3];
                    stringArray[0] = this.bandle.getString("LABEL_CANCEL");
                    stringArray[1] = this.bandle.getString("LABEL_DECRYPT_SHORT");
                    objectArray = stringArray;
                    stringArray[2] = this.bandle.getString("LABEL_ENCRYPT");
                }
                Object[] buttons = objectArray;
                int result = JOptionPane.showOptionDialog(frame, this.bandle.getString("MSG_SELECT_ACTION"), this.bandle.getString("ENCRYPT_DECRYPT_SELECT_DIALOG"), 1, 3, new ImageIcon(this.getClass().getResource("/icon_help.png")), buttons, Utility.isMac() ? buttons[1] : buttons[2]);
                if (result == -1) {
                    return;
                }
                Object buttonLabel = buttons[result];
                if (((String)buttonLabel).equals(this.bandle.getString("LABEL_CANCEL"))) {
                    return;
                }
                boolean mode = ((String)buttonLabel).equals(this.bandle.getString("LABEL_ENCRYPT"));
                if (mode) {
                    this.version = -1;
                }
            }
            if (this.version == -1) {
                this.encryptAction.actionPerformed(null);
            } else {
                this.decryptAction.actionPerformed(null);
            }
        }
    }

    private class DecryptAction
    extends AbstractAction {
        private static final long serialVersionUID = 8121598904661486893L;
        private AbstractAction cancelAction = null;

        public DecryptAction() {
            this.putValue("Name", AttacheCase4GUI.this.bandle.getString("MENU_DECRYPT_FILE"));
            this.putValue("ShortDescription", AttacheCase4GUI.this.bandle.getString("MENU_DECRYPT_FILE_SHORT_DESCRIPTION"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!frame.isVisible()) {
                frame.setVisible(true);
            }
            ArrayList<String> fileNameList = new ArrayList<String>();
            if (AttacheCase4GUI.this.fileList == null || AttacheCase4GUI.this.fileList.size() == 0) {
                AttacheCase4GUI.this.fileList = AttacheCase4GUI.this.confirm.getFiles(null, "\u30d5\u30a1\u30a4\u30eb\u9078\u629e", 0, new AtcFileFilter());
                if (AttacheCase4GUI.this.fileList.size() == 0) {
                    return;
                }
            }
            for (File f : AttacheCase4GUI.this.fileList) {
                fileNameList.add(f.getAbsolutePath());
            }
            AttacheCase4GUI.this.options.setDecryptFileNames(fileNameList);
            this.cancelAction = new AbstractAction(){
                private static final long serialVersionUID = -1244369977167704186L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AttacheCase4GUI.this.encryptWorker != null) {
                        AttacheCase4GUI.this.encryptWorker.cancel(true);
                    }
                }
            };
            AttacheCase4GUI.this.cancelButton.removeActionListener(AttacheCase4GUI.this.quitAction);
            AttacheCase4GUI.this.cancelButton.addActionListener(this.cancelAction);
            AttacheCase4GUI.this.cancelButton.setLabel(AttacheCase4GUI.this.bandle.getString("SELECT_OPTION_CANCEL"));
            AttacheCase4GUI.this.encryptWorker = new SwingWorker<Void, Integer>(){
                private Encrypt encrypt = null;
                private String oldFileName = "";

                @Override
                protected Void doInBackground() throws Exception {
                    AttacheCase4GUI.this.progressBar.setVisible(true);
                    AttacheCase4GUI.this.progressBar.setValue(0);
                    this.encrypt = AttacheCase4GUI.this.version == 2 ? new FileDecrypt2(false, AttacheCase4GUI.this.options, AttacheCase4GUI.this.confirm) : new FileDecrypt3(false, AttacheCase4GUI.this.options, AttacheCase4GUI.this.confirm);
                    this.encrypt.run(new AbstractProgressListener(){

                        @Override
                        public void publishProgress(int value) {
                            this.publish(new Integer[]{value});
                        }

                        @Override
                        public void publishFileName(String fileName) {
                            this.firePropertyChange("currentfilename", oldFileName, fileName);
                            oldFileName = fileName;
                        }

                        @Override
                        public boolean isCancel() {
                            return this.isCancelled();
                        }
                    });
                    return null;
                }

                @Override
                protected void done() {
                    if (this.isCancelled() || this.encrypt != null && !this.encrypt.isComplete()) {
                        AttacheCase4GUI.this.confirm.showMessageByBundle("MSG_STOPPED");
                    } else if (this.encrypt != null) {
                        this.encrypt.isComplete();
                    }
                    AttacheCase4GUI.this.progressBar.setVisible(false);
                    if (AttacheCase4GUI.this.fileList != null) {
                        AttacheCase4GUI.this.fileList = null;
                    }
                    AttacheCase4GUI.this.statusText.setText(AttacheCase4GUI.this.bandle.getString("MSG_DECRYPT_END"));
                    AttacheCase4GUI.this.cancelButton.removeActionListener(DecryptAction.this.cancelAction);
                    AttacheCase4GUI.this.cancelButton.addActionListener(AttacheCase4GUI.this.quitAction);
                    AttacheCase4GUI.this.cancelButton.setLabel(AttacheCase4GUI.this.bandle.getString("MENU_QUIT"));
                    if (AttacheCase4GUI.this.options.isQuitAfterEncrypt()) {
                        AttacheCase4GUI.this.quit();
                    }
                }

                @Override
                protected void process(List<Integer> chunks) {
                    for (Integer i : chunks) {
                        this.setProgress(i);
                    }
                }
            };
            AttacheCase4GUI.this.encryptWorker.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("progress".equals(evt.getPropertyName())) {
                        AttacheCase4GUI.this.progressBar.setValue((Integer)evt.getNewValue());
                    } else if ("currentfilename".equals(evt.getPropertyName())) {
                        AttacheCase4GUI.this.statusText.setText("" + evt.getNewValue());
                    }
                }
            });
            AttacheCase4GUI.this.statusText.setText(AttacheCase4GUI.this.bandle.getString("MSG_DECRYPT_START"));
            AttacheCase4GUI.this.encryptWorker.execute();
        }
    }

    private class EncryptAction
    extends AbstractAction {
        private static final long serialVersionUID = 3743129248681047677L;
        private AbstractAction cancelAction = null;

        public EncryptAction() {
            this.putValue("Name", AttacheCase4GUI.this.bandle.getString("MENU_ENCRYPT_FILE"));
            this.putValue("ShortDescription", AttacheCase4GUI.this.bandle.getString("MENU_ENCRYPT_FILE_SHORT_DESCRIPTION"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayList<String> fileNameList = new ArrayList<String>();
            if (AttacheCase4GUI.this.fileList == null || AttacheCase4GUI.this.fileList.size() == 0) {
                AttacheCase4GUI.this.fileList = AttacheCase4GUI.this.confirm.getFiles(null, AttacheCase4GUI.this.bandle.getString("DIALOG_TITLE_ENCRYPT_FILE"), 0, null);
                if (AttacheCase4GUI.this.fileList.size() == 0) {
                    return;
                }
            }
            for (File f : AttacheCase4GUI.this.fileList) {
                fileNameList.add(f.getAbsolutePath());
            }
            AttacheCase4GUI.this.options.setEncryptFileNames(fileNameList);
            this.cancelAction = new AbstractAction(){
                private static final long serialVersionUID = -1244369977167704186L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AttacheCase4GUI.this.encryptWorker != null) {
                        AttacheCase4GUI.this.encryptWorker.cancel(true);
                    }
                }
            };
            AttacheCase4GUI.this.cancelButton.removeActionListener(AttacheCase4GUI.this.quitAction);
            AttacheCase4GUI.this.cancelButton.addActionListener(this.cancelAction);
            AttacheCase4GUI.this.cancelButton.setLabel(AttacheCase4GUI.this.bandle.getString("SELECT_OPTION_CANCEL"));
            AttacheCase4GUI.this.encryptWorker = new SwingWorker<Void, Integer>(){
                private Encrypt encrypt = null;
                private String oldFileName = "";

                @Override
                protected Void doInBackground() throws Exception {
                    AttacheCase4GUI.this.progressBar.setVisible(true);
                    AttacheCase4GUI.this.progressBar.setValue(0);
                    this.encrypt = AttacheCase4GUI.this.options.isUseVersion2() ? new FileEncrypt(false, AttacheCase4GUI.this.options, AttacheCase4GUI.this.confirm) : new FileEncrypt3(false, AttacheCase4GUI.this.options, AttacheCase4GUI.this.confirm);
                    AttacheCase4GUI.this.setPassword(this.encrypt);
                    this.encrypt.run(new AbstractProgressListener(){

                        @Override
                        public void publishProgress(int value) {
                            this.publish(new Integer[]{value});
                        }

                        @Override
                        public void publishFileName(String fileName) {
                            this.firePropertyChange("currentfilename", oldFileName, fileName);
                            oldFileName = fileName;
                        }

                        @Override
                        public boolean isCancel() {
                            return this.isCancelled();
                        }
                    });
                    return null;
                }

                @Override
                protected void done() {
                    if (this.isCancelled() || this.encrypt != null && !this.encrypt.isComplete()) {
                        AttacheCase4GUI.this.confirm.showMessageByBundle("MSG_STOPPED");
                    } else if (this.encrypt != null) {
                        this.encrypt.isComplete();
                    }
                    AttacheCase4GUI.this.progressBar.setVisible(false);
                    if (AttacheCase4GUI.this.fileList != null) {
                        AttacheCase4GUI.this.fileList = null;
                    }
                    AttacheCase4GUI.this.statusText.setText(AttacheCase4GUI.this.bandle.getString("MSG_ENCRYPT_END"));
                    AttacheCase4GUI.this.cancelButton.removeActionListener(EncryptAction.this.cancelAction);
                    AttacheCase4GUI.this.cancelButton.addActionListener(AttacheCase4GUI.this.quitAction);
                    AttacheCase4GUI.this.cancelButton.setLabel(AttacheCase4GUI.this.bandle.getString("MENU_QUIT"));
                    if (AttacheCase4GUI.this.options.isQuitAfterEncrypt()) {
                        AttacheCase4GUI.this.quit();
                    }
                }

                @Override
                protected void process(List<Integer> chunks) {
                    for (Integer i : chunks) {
                        this.setProgress(i);
                    }
                }
            };
            AttacheCase4GUI.this.encryptWorker.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("progress".equals(evt.getPropertyName())) {
                        AttacheCase4GUI.this.progressBar.setValue((Integer)evt.getNewValue());
                    } else if ("currentfilename".equals(evt.getPropertyName())) {
                        AttacheCase4GUI.this.statusText.setText("" + evt.getNewValue());
                    }
                }
            });
            AttacheCase4GUI.this.statusText.setText(AttacheCase4GUI.this.bandle.getString("MSG_ENCRYPT_START"));
            AttacheCase4GUI.this.encryptWorker.execute();
        }
    }

    private class QuitAction
    extends AbstractAction {
        private static final long serialVersionUID = -3178962834401876853L;

        public QuitAction() {
            this.putValue("Name", AttacheCase4GUI.this.bandle.getString("MENU_QUIT"));
            this.putValue("ShortDescription", AttacheCase4GUI.this.bandle.getString("MENU_QUIT_DESCRIPTION"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AttacheCase4GUI.this.quit();
        }
    }

    private class SettingAction
    extends AbstractAction {
        private static final long serialVersionUID = -1213442520167632698L;

        public SettingAction() {
            this.putValue("Name", AttacheCase4GUI.this.bandle.getString("MENU_SETTING"));
            this.putValue("ShortDescription", AttacheCase4GUI.this.bandle.getString("MENU_SETTING_DESCRIPTION"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OptionDialog dialog = new OptionDialog(frame, AttacheCase4GUI.this.options);
            dialog.setVisible(true);
            if (!dialog.isCanceled()) {
                AttacheCase4GUI.this.options = dialog.getOptions();
            }
        }
    }
}

