/*
 * Decompiled with CFR 0.152.
 */
package org.hibara.attachecase;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ResourceBundle;
import org.hibara.attachecase.AttacheCaseConstant;
import org.hibara.attachecase.Confirm;
import org.hibara.attachecase.ConsoleConfirm;
import org.hibara.attachecase.Options;
import org.hibara.attachecase.encrypt.Encrypt;
import org.hibara.attachecase.encrypt.FileDecrypt2;
import org.hibara.attachecase.encrypt.FileDecrypt3;
import org.hibara.attachecase.encrypt.FileEncrypt;
import org.hibara.attachecase.encrypt.FileEncrypt3;
import org.hibara.attachecase.entity.ShaEntity;
import org.hibara.attachecase.exception.PasswordException;
import org.hibara.attachecase.utility.Digest;
import org.hibara.attachecase.utility.Utility;

public class AttacheCase4CUI
implements AttacheCaseConstant {
    private Options options = null;
    private Confirm confirm = null;

    public AttacheCase4CUI(Options options) {
        this.options = options;
    }

    public void run() {
        if (this.options.getRunMode() == 3) {
            this.showVersion();
            return;
        }
        this.confirm = new ConsoleConfirm();
        try {
            if (this.options.getRunMode() == 1) {
                this.decrypt();
            } else if (this.options.getRunMode() == 2) {
                this.encrypt();
            }
        }
        catch (FileNotFoundException e) {
            Object[] replaceMessages = new Object[]{e.getMessage()};
            String msg = Utility.replacePlaceHolder(ResourceBundle.getBundle("org.hibara.attachecase.resource").getString("MSG_ERROR_NOT_FILE_EXIST"), replaceMessages);
            this.confirm.showErrorMessage(msg);
        }
        catch (IOException e) {
            Object[] replaceMessages = new Object[]{this.options.getRunMode() == 2 ? this.options.getEncryptPasswordFileName() : this.options.getDecryptPasswordFileName()};
            String msg = Utility.replacePlaceHolder(ResourceBundle.getBundle("org.hibara.attachecase.resource").getString("MSG_ERROR_NOT_FILE_EXIST"), replaceMessages);
            this.confirm.showErrorMessage(msg);
        }
        catch (PasswordException e) {
            this.confirm.showErrorMessageByBundle("MSG_ERROR_ILLEGAL_PASSWORD");
        }
    }

    private void encrypt() throws IOException, PasswordException {
        FileEncrypt encrypt = null;
        encrypt = this.options.isUseVersion2() ? new FileEncrypt(false, this.options) : new FileEncrypt3(false, this.options);
        this.setPassword(encrypt);
        encrypt.run(null);
        encrypt.isComplete();
    }

    private void decrypt() throws FileNotFoundException, IOException, PasswordException {
        for (String path : this.options.getDecryptFileNames()) {
            int version = Utility.getAtcVersion(new File(path));
            Encrypt decrypt = null;
            switch (version) {
                case 2: {
                    decrypt = new FileDecrypt2(false, this.options);
                    break;
                }
                case 3: {
                    decrypt = new FileDecrypt3(false, this.options);
                }
            }
            if (decrypt == null) continue;
            decrypt.run(null);
            decrypt.isComplete();
        }
    }

    private void showVersion() {
        String s = ResourceBundle.getBundle("org.hibara.attachecase.resource").getString("MSG_VERSION");
        Object[] param = new Object[]{"0.73"};
        System.out.printf("\n %s", Utility.replacePlaceHolder(s, param));
    }

    private void setPassword(Encrypt encrypt) throws IOException, PasswordException {
        if (!this.options.isEncryptPasswordRequired() && this.options.isUsePasswordOption()) {
            encrypt.setPassword(this.options.getDecryptPassword());
        } else if (!this.options.isEncryptPasswordRequired() && this.options.getEncryptPasswordFileName() != null) {
            Digest digest = new Digest();
            ShaEntity sha = digest.getHash(this.options.getEncryptPasswordFileName());
            encrypt.setSha(sha);
        } else if (!this.options.isEncryptPasswordRequired() && this.options.getEncryptPassword() != null) {
            encrypt.setPassword(Utility.decrypt(Confirm.resources.getString("APP_FRAME_NAME"), this.options.getEncryptPassword()));
        } else {
            String password = this.confirm.inputPassword(2);
            if (password == null) {
                throw new PasswordException();
            }
            this.options.setEncryptPasswardRequired(false);
            encrypt.setPassword(password);
        }
    }
}

