/*
 * Decompiled with CFR 0.152.
 */
package org.hibara.attachecase;

import com.apple.eawt.AppEvent;
import com.apple.eawt.Application;
import com.apple.eawt.OpenFilesHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.hibara.attachecase.AttacheCase4CUI;
import org.hibara.attachecase.AttacheCase4GUI;
import org.hibara.attachecase.Confirm;
import org.hibara.attachecase.GuiForMac;
import org.hibara.attachecase.Options;
import org.hibara.attachecase.utility.Utility;

public class AttacheCase
implements Runnable {
    private String[] args = null;

    private AttacheCase(String[] args) {
        this.args = args;
    }

    public static void main(String[] args) throws Exception {
        Options options = new Options(args);
        if (options.isCui()) {
            AttacheCase4CUI obj = new AttacheCase4CUI(options);
            obj.run();
        } else {
            if (options.isNotMulipleStarts() && AttacheCase.isMultipleStarts()) {
                return;
            }
            SwingUtilities.invokeLater(new AttacheCase(args));
        }
    }

    @Override
    public void run() {
        if (Utility.isMac()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", Confirm.resources.getString("APP_FRAME_NAME"));
        }
        Options options = new Options(this.args);
        final AttacheCase4GUI gui = new AttacheCase4GUI();
        gui.setOptions(options);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            if (Utility.isMac()) {
                GuiForMac.setUp(gui);
                Application app = Application.getApplication();
                app.setOpenFileHandler(new OpenFilesHandler(){

                    public void openFiles(AppEvent.OpenFilesEvent evt) {
                        List files = evt.getFiles();
                        gui.setFileList(files);
                        gui.run();
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        gui.setVisible(true);
    }

    public static boolean isMultipleStarts() {
        FileLock lock;
        FileChannel fc;
        FileOutputStream fos;
        File lockFile;
        block3: {
            lockFile = new File(Utility.getStartupPath(), "lock_attachecase");
            fos = new FileOutputStream(lockFile);
            fc = fos.getChannel();
            lock = fc.tryLock();
            if (lock != null) break block3;
            return true;
        }
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        if (lock != null && lock.isValid()) {
                            lock.release();
                        }
                        fc.close();
                        fos.close();
                        lockFile.delete();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }
}

